<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

$BASE_URL = "https://api.alanchand.com/";
$TOKEN = "q2fL7wAepMJnhX8KChgfjhwadR3B";

$type = $_POST['type'] ?? $_GET['type'] ?? null;
$type = strtolower(trim($type));

$filterSymbols = $_POST['symbols'] ?? $_GET['symbols'] ?? null;

$validTypes = [
    'currencies' => 'currencies',
    'crypto' => 'crypto',
    'gold' => 'golds',
    'golds' => 'golds'
];

if (!isset($validTypes[$type])) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Invalid type specified. Please use "currencies", "crypto", or "gold".'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$apiUrl = $BASE_URL . "?type=" . $validTypes[$type] . "&token=$TOKEN";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

if (!$response || !$data) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Internal Server Error'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($filterSymbols) {
    $symbolsArr = array_map('strtolower', explode(',', $filterSymbols));
    $filtered = [];

    foreach ($data as $key => $value) {
        if (in_array(strtolower($key), $symbolsArr)) {
            $filtered[$key] = $value;
        }
    }

    if (empty($filtered)) {
        echo json_encode([
            'ok' => false,
            'dev' => '@OnyxApiTeam',
            'error' => 'None of the requested symbols were found in the data.'
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        exit;
    }

    $data = $filtered;
}

echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'data' => $data
], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
