<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$audioUrl = null;

if ($method === 'GET') {
    $audioUrl = $_GET['url'] ?? null;
} elseif ($method === 'POST') {
    if (isset($_POST['url'])) {
        $audioUrl = $_POST['url'];
    } else {
        $body = file_get_contents('php://input');
        $data = json_decode($body, true);
        if ($data && isset($data['url'])) {
            $audioUrl = $data['url'];
        }
    }
}

if (!$audioUrl || trim($audioUrl) === '') {
    http_response_code(400);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Missing or empty "url" parameter'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$apiEndpoint = 'https://t2v.cactus-dev.ir';
$params = ['url' => $audioUrl];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiEndpoint . '?' . http_build_query($params));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$response = curl_exec($ch);
$status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

if ($status !== 200) {
    http_response_code($status);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => $data['error'] ?? $response
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($data === null) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Invalid response from transcription API'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'text' => $data['text'] ?? 'null'
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
