<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Content-Type: application/json');

$bioFile = __DIR__ . '/bio.json';

if (!file_exists($bioFile)) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Bio not found'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Method Not Allowed'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$response = file_get_contents($bioFile);
$bioData = json_decode($response, true);
$randomBio = $bioData[array_rand($bioData)]['content'];

echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'bio' => $randomBio
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
