<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json; charset=UTF-8');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

function fetchHTML($url) {
    $context = stream_context_create([
        'http' => [
            'header' => "User-Agent: Mozilla/5.0\r\n"
        ]
    ]);
    return file_get_contents($url, false, $context);
}

function parseDOM($html) {
    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    libxml_clear_errors();
    return new DOMXPath($dom);
}

function extractAgeDetails($xpath) {
    $nodes = $xpath->query('//div[contains(@class,"alert shadow")]');
    $items = [];
    foreach ($nodes as $node) {
        $items[] = trim($node->textContent);
    }
    return ['age_details' => $items];
}

function extractInterestingDays($xpath) {
    $nodes = $xpath->query('//div[contains(@class,"col-12 col-lg-6 text-center")]');
    $items = [];
    foreach ($nodes as $node) {
        $items[] = trim($node->textContent);
    }
    return ['interesting_days' => $items];
}

function extractFamousPeople($xpath) {
    $nodes = $xpath->query('//td');
    $people = [];
    for ($i = 3; $i + 2 < $nodes->length; $i += 3) {
        $people[] = [
            'birth_year' => trim($nodes[$i]->textContent),
            'name' => trim($nodes[$i + 1]->textContent),
            'job' => trim($nodes[$i + 2]->textContent),
        ];
    }
    return ['famous_people' => $people];
}

function getData($year, $month, $day) {
    $url = "https://vahidmajidi.com/{$year}-{$month}-{$day}/%D9%85%D8%AD%D8%A7%D8%B3%D8%A8%D9%87-%D8%B3%D9%86";
    $html = fetchHTML($url);
    if (!$html) return null;

    $xpath = parseDOM($html);
    return array_merge(
        extractAgeDetails($xpath),
        extractFamousPeople($xpath),
        extractInterestingDays($xpath)
    );
}

// Get input
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $year = $input['year'] ?? null;
    $month = $input['month'] ?? null;
    $day = $input['day'] ?? null;
} else {
    $year = $_GET['year'] ?? null;
    $month = $_GET['month'] ?? null;
    $day = $_GET['day'] ?? null;
}

if ($year && $month && $day) {
    $result = getData($year, $month, $day);

    if (!empty($result)) {
        echo json_encode([
            'ok' => true,
            'dev' => '@Cactus_Dev',
            'data' => $result
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    } else {
        echo json_encode([
            'ok' => false,
            'dev' => '@Cactus_Dev',
            'error' => 'Failed to fetch data. Please check the provided date.'
        ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    }
} else {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'error' => 'Missing required parameters: year, month, and day.'
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
}
