<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $type = isset($input['type']) ? strtolower(trim($input['type'])) : null;
} else {
    $type = isset($_GET['type']) ? strtolower(trim($_GET['type'])) : null;
}

if (!$type) {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'error' => 'پارامتر type لازم است.'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

function send_req($type)
{
    $url = "https://api.coingecko.com/api/v3/coins/{$type}";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200) {
        return null;
    }

    return json_decode($response, true);
}

$data = send_req($type);

if (!$data) {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'error' => "ارز {$type} یافت نشد یا اطلاعات موجود نیست."
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$result = [
    'name' => $data['name'] ?? null,
    'symbol' => strtoupper($data['symbol'] ?? ''),
    'current_price' => $data['market_data']['current_price']['usd'] ?? null,
    'market_cap' => $data['market_data']['market_cap']['usd'] ?? null,
    '24h_volume' => $data['market_data']['total_volume']['usd'] ?? null,
    'price_change_percentage_24h' => $data['market_data']['price_change_percentage_24h'] ?? null,
    'price_change_percentage_7d' => $data['market_data']['price_change_percentage_7d'] ?? null,
    'price_change_percentage_30d' => $data['market_data']['price_change_percentage_30d'] ?? null,
    'all_time_high' => $data['market_data']['ath']['usd'] ?? null,
    'all_time_high_date' => $data['market_data']['ath_date']['usd'] ?? null,
    'all_time_low' => $data['market_data']['atl']['usd'] ?? null,
    'all_time_low_date' => $data['market_data']['atl_date']['usd'] ?? null,
];

echo json_encode([
    'ok' => true,
    'dev' => '@Cactus_Dev',
    'result' => $result
], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
