<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

date_default_timezone_set("Asia/Tehran");

$result = [
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "total_count" => null,
    "timestamp" => null,
    "result" => []
];

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api.excoino.com/api/v4/core/top-cryptos',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'accept-charset: UTF-8',
        'accept-encoding: gzip',
        'accept-language: fa',
        'access-control-allow-origin: *',
        'authorization: bearer null',
        'content-type: application/json',
        'host: api.excoino.com',
        'pwa: 0',
        'user-agent: AMApp-Excoino',
        'version: 1357'
    ],
]);

$response = json_decode(curl_exec($curl), true);
$err = curl_error($curl);
curl_close($curl);

$result["total_count"] = isset($response["data"]) ? count($response["data"]) : null;
$result["timestamp"] = isset($response["time"]) ? date("Y-m-d H:i:s D-a", (int) ($response["time"] / 1000)) : null;
$result["result"] = isset($response["data"]) ? $response["data"] : $err;

echo json_encode(
    $result,
    JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE
);