<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

date_default_timezone_set('Asia/Tehran');

function send_request($url)
{
    $randIP = mt_rand(1, 255) . "." . mt_rand(0, 255) . "." . mt_rand(0, 255) . "." . mt_rand(1, 254);

    $headers = [
        'Accept: text/html,application/xhtml+xml',
        'CLIENT-IP: ' . $randIP,
        'X-FORWARDED-FOR: ' . $randIP,
        'REMOTE_ADDR: ' . $randIP
    ];

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
        CURLOPT_HTTPHEADER => $headers
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

function fa_to_en($string)
{
    $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹', '٬', '٫'];
    $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '', ','];
    return str_replace($persian, $english, $string);
}

function extract_currencies($html)
{
    $list = [];

    libxml_use_internal_errors(true);
    $dom = new DOMDocument();
    $dom->loadHTML($html);
    $xpath = new DOMXPath($dom);

    $cards = $xpath->query('//div[contains(@class, "finance-card")]');

    foreach ($cards as $card) {
        $nameNode = $xpath->query('.//h6', $card)->item(0);
        $priceNode = $xpath->query('.//span[contains(@class, "value")]', $card)->item(0);
        $changeNode = $xpath->query('.//small[contains(@class, "style-percent")]', $card)->item(0);

        if ($nameNode && $priceNode) {
            $name = trim($nameNode->textContent);
            $priceText = fa_to_en(trim($priceNode->textContent));
            $change = $changeNode ? trim($changeNode->textContent) : '';
            $change = fa_to_en($change) . '%';

            $price = (int) preg_replace('/[^\d]/', '', $priceText);

            $list[] = [
                'name' => $name,
                'price' => $price,
                'change' => $change
            ];
        }
    }

    return $list;
}

$html = send_request('https://www.iranintl.com/finance');
$currencyList = extract_currencies($html);

$output = [
    'ok' => true,
    'dev' => '@Cactus_Dev',
    'date' => date('Y/m/d, H:i'),
    'currencies' => $currencyList
];

header('Content-Type: application/json; charset=utf-8');
echo json_encode($output, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);