<?php
error_reporting(0);
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=utf-8');

$method = $_SERVER['REQUEST_METHOD'];
$input = [];

if ($method === 'POST') {
    $raw = file_get_contents('php://input');
    $input = json_decode($raw, true);
    if (!is_array($input)) {
        $input = $_POST;
    }
} else {
    $input = $_GET;
}

$domainParam = $input['domain'] ?? null;
if (!$domainParam) {
    http_response_code(400);
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'results' => 'Missing or empty "domain" parameter.'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

$dm = str_ireplace(['http://','https://','http://www.','https://www.'], '', trim($domainParam));
$response = @file_get_contents("https://intodns.com/" . urlencode($dm));

if (!$response) {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'results' => [
            'domain' => $dm,
            'ip' => null,
            'dns' => []
        ]
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

if (strpos($response, 'I only check domains not subdomains') !== false) {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'results' => 'Subdomains are not supported. Please enter a root domain like example.com'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

preg_match_all('~<strong>([a-zA-Z0-9.\-]+)</strong>~si', $response, $matches);

$name = '';
for ($i = 1; $i < count($matches[1]); $i++) {
    if (strpos($matches[1][$i], 'ns') !== false) {
        $name .= $matches[1][$i] . "\n";
    }
}

$dnsArray = array_filter(array_map('trim', explode("\n", $name)));
$ip = preg_match('#([0-9]+)#', str_replace('.', '', $matches[1][0])) ? $matches[1][0] : ($matches[1][1] ?? null);

echo json_encode([
    'ok' => true,
    'dev' => '@Cactus_Dev',
    'results' => [
        'domain' => $dm,
        'ip' => $ip,
        'dns' => array_values($dnsArray)
    ]
], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
