<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'dev' => '@Cactus_Dev', 'error' => 'Method not allowed'], JSON_UNESCAPED_UNICODE);
    exit;
}

function fetchData() {
    $url = 'https://www.tasvirezendegi.com/wp-admin/admin-ajax.php?action=acm_fal&id=32100&count=1';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Accept: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; PHP API)');
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        return ['ok' => false, 'dev' => '@Cactus_Dev', 'error' => 'cURL error: ' . $error];
    }
    
    if ($httpCode !== 200) {
        return ['ok' => false, 'dev' => '@Cactus_Dev', 'error' => 'Request was not successful'];
    }
    
    $data = json_decode($response, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        return ['ok' => false, 'dev' => '@Cactus_Dev', 'error' => 'Invalid JSON response'];
    }
    
    if (!isset($data['success']) || !$data['success'] || !isset($data['data'])) {
        return ['ok' => false, 'dev' => '@Cactus_Dev', 'error' => 'Request was not successful'];
    }
    
    $html = $data['data'];
    
    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML('<?xml encoding="utf-8" ?>' . $html);
    libxml_clear_errors();
    
    $imageLink = '';
    $images = $dom->getElementsByTagName('img');
    if ($images->length > 0) {
        $imageLink = $images->item(0)->getAttribute('src');
    }
    
    $text = strip_tags($html);
    $lines = explode("\n", $text);
    $cleanLines = [];
    foreach ($lines as $line) {
        $line = trim($line);
        if (!empty($line)) {
            $cleanLines[] = $line;
        }
    }
    $text = implode("\n\n", $cleanLines);
    
    return [
        'ok' => true,
        'dev' => '@Cactus_Dev',
        'text' => $text,
        'imagelink' => $imageLink
    ];
}

$result = fetchData();

if ($result['ok']) {
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    http_response_code(500);
    echo json_encode($result, JSON_UNESCAPED_UNICODE);
}
?>
