<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

class Hafez
{
    private $url;
    private $timeout;
    private $connectTimeout;

    public function __construct($url = "https://www.hafez.it/tabir/", $timeout = 5, $connectTimeout = 3)
    {
        $this->url = $url;
        $this->timeout = $timeout;
        $this->connectTimeout = $connectTimeout;
    }

    private function fetchContent()
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $this->connectTimeout);
        curl_setopt($ch, CURLOPT_TIMEOUT, $this->timeout);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_2_0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception('Curl error: ' . curl_error($ch));
        }

        curl_close($ch);
        return $response;
    }

    private function parseFal($content)
    {
        preg_match_all('#<div class="faal_poem container">\s*(.*?)\s*</div>#', $content, $falMatches);
        $fal = isset($falMatches[1][0]) ? $falMatches[1][0] : null;

        if ($fal) {
            $fal = strip_tags(str_replace('</p>', "\n", $fal));
        }

        return $fal;
    }

    private function parseTabir($content)
    {
        preg_match_all('#<div class="col-md-6">\s*<h2>تعبیر فال شما</h2><p>(.*?)</p>\s*</div>#', $content, $tabirMatches);
        return isset($tabirMatches[1][0]) ? $tabirMatches[1][0] : null;
    }

    private function parseAudio($content)
    {
        preg_match_all('#<source src="(.*?)" type="audio/mp3">#', $content, $audioMatches);
        return isset($audioMatches[1][0]) ? $audioMatches[1][0] : null;
    }

    public function getFalData()
    {
        try {
            $content = $this->fetchContent();

            $fal = $this->parseFal($content);
            $tabir = $this->parseTabir($content);
            $audio = $this->parseAudio($content);

            header('Content-Type: application/json; charset=UTF-8');

            return json_encode([
                'ok' => true,
                'dev' => '@Cactus_Dev',
                'fal' => $fal,
                'tabir' => $tabir,
                'audio' => $audio
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

        } catch (Exception $e) {
            header('Content-Type: application/json; charset=UTF-8');
            return json_encode([
                'ok' => false,
                'dev' => '@Cactus_Dev',
                'error' => $e->getMessage()
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        }
    }
}

$Horoscope = new Hafez();
echo $Horoscope->getFalData();