<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

function fetchData($url) {
    $headers = [
        "Accept: application/json",
        "Accept-Language: fa-IR,fa;q=0.9,en-US;q=0.8,en;q=0.7",
        "User-Agent: Mozilla/5.0",
        "X-App-Version: 12",
        "X-Client-Locale: fa-IR",
        "X-Platform: web",
        "X-Seconds-From-UTC: 12600",
        "X-UDID: fd838856-3558-4aaf-80ae-9b5b7d3dc92e",
        "X-User-AS: MCCI"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err || !$res) {
        return null;
    }

    return json_decode($res, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $type = $input['type'] ?? null;
    $id = $input['id'] ?? null;
    $filterKey = $input['filter'] ?? null;
} else {
    $type = $_GET['type'] ?? null;
    $id = $_GET['id'] ?? null;
    $filterKey = $_GET['filter'] ?? null;
}

$options = JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT;

$newsFilters = [
    "all"      => "news/latest?version=2",
    "internal" => "news/latest/2?version=2",
    "external" => "news/latest/3?version=2"
];

$customFilterList = [
    ["title" => "همه",    "key" => "all"],
    ["title" => "داخلی",  "key" => "internal"],
    ["title" => "خارجی",  "key" => "external"]
];

if ($type === 'matches') {
    $url = $id ? "https://api.footballi.net/api/v2/match/tab/$id" : "https://api.footballi.net/api/v2/match/tab/";
    $data = fetchData($url);

    if (!$data || !isset($data['data'])) {
        echo json_encode([
            "ok"    => false,
            "dev"   => "@Cactus_Dev",
            "error" => "Failed to fetch match data"
        ], $options);
        exit;
    }

    echo json_encode([
        "ok"      => true,
        "dev"     => "@Cactus_Dev",
        "tabs"    => $data['data']['tabs'] ?? [],
        "matches" => $data['data']['competition_matches'] ?? []
    ], $options);
    exit;
}

if ($type === 'tabs') {
    $url = "https://api.footballi.net/api/v2/match/tab/";
    $data = fetchData($url);

    if (!$data || !isset($data['data']['tabs'])) {
        echo json_encode([
            "ok"    => false,
            "dev"   => "@Cactus_Dev",
            "error" => "Failed to fetch tab list"
        ], $options);
        exit;
    }

    echo json_encode([
        "ok"   => true,
        "dev"  => "@Cactus_Dev",
        "tabs" => $data['data']['tabs']
    ], $options);
    exit;
}

if ($type === 'transfers') {
    $url = "https://api.footballi.net/api/v2/transfer/homepage";
    $data = fetchData($url);

    if (!$data || !isset($data['data']['list'])) {
        echo json_encode([
            "ok"    => false,
            "dev"   => "@Cactus_Dev",
            "error" => "Failed to fetch transfer data"
        ], $options);
        exit;
    }

    echo json_encode([
        "ok"        => true,
        "dev"       => "@Cactus_Dev",
        "transfers" => $data['data']['list']
    ], $options);
    exit;
}

if ($type === 'news') {
    $endpoint = $newsFilters[$filterKey] ?? $newsFilters["all"];
    $url = "https://api.footballi.net/api/v2/" . $endpoint;
    $data = fetchData($url);

    if (!$data || !isset($data['data']['news'])) {
        echo json_encode([
            "ok"    => false,
            "dev"   => "@Cactus_Dev",
            "error" => "Failed to fetch news data"
        ], $options);
        exit;
    }

    echo json_encode([
        "ok"      => true,
        "dev"     => "@Cactus_Dev",
        "filters" => $customFilterList,
        "news"    => $data['data']['news']
    ], $options);
    exit;
}

echo json_encode([
    "ok"    => false,
    "dev"   => "@Cactus_Dev",
    "error" => "Missing or invalid ?type=matches|transfers|news|tabs"
], $options);
