<?php
header('Content-type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *'); 
header('Access-Control-Allow-Methods: GET, POST, OPTIONS'); 
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

$types = [
    "alaky" => ["url" => "https://4jok.com/jok/76", "maxPage" => 37],
    "bgh" => ["url" => "https://4jok.com/jok/67", "maxPage" => 82],
    "dastan" => ["url" => "https://4jok.com/text/63", "maxPage" => 164],
    "deghat_kardin" => ["url" => "https://4jok.com/jok/64", "maxPage" => 246],
    "dialog" => ["url" => "https://4jok.com/text/81", "maxPage" => 107],
    "etraf" => ["url" => "https://4jok.com/jok/62", "maxPage" => 270],
    "famil" => ["url" => "https://4jok.com/jok/50", "maxPage" => 600],
    "fantasy" => ["url" => "https://4jok.com/jok/61", "maxPage" => 172],
    "jok" => ["url" => "https://4jok.com/jok/59", "maxPage" => 500],
    "sms" => ["url" => "https://4jok.com/sms/13", "maxPage" => 82],
    "pnp" => ["url" => "https://4jok.com/jok/51", "maxPage" => 97]
];

$type = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $type = $input['type'] ?? null;
} else {
    $type = $_GET['type'] ?? null;
}

if(!$type || !isset($types[$type])){
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "Type parameter is required and must be valid."
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function jok4($url, $page){
    while (true) {
        $doc = new DOMDocument();
        @$html = file_get_contents($url . '/' . $page);
        if ($html === false) {
            continue;
        }
        libxml_use_internal_errors(true);
        $doc->loadHTML($html);
        libxml_clear_errors();
        $xpath = new DOMXPath($doc);
        $getUrl = $xpath->query("//p");
        if($getUrl->length === 0){
            continue;
        }
        $text = trim($getUrl[random_int(0, min(15, $getUrl->length - 1))]->textContent);
        if(!empty($text) && strlen(preg_replace('/\s+/u', '', $text)) > 0){
            return $text;
        }
    }
}

$page = random_int(1, $types[$type]["maxPage"]);
$result = [
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "result" => jok4($types[$type]["url"], $page)
];

echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
