<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

$db_host = "localhost";
$db_name = "cactusde_gemini";
$db_user = "cactusde_gemini";
$db_pass = "www09148215271s";

try {
    $pdo = new PDO(
        "mysql:host=$db_host;dbname=$db_name;charset=utf8mb4",
        $db_user,
        $db_pass,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
} catch (PDOException $e) {
    die(json_encode([
        "success" => false,
        "error" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE));
}

$pdo->exec("
    CREATE TABLE IF NOT EXISTS chats (
        id INT AUTO_INCREMENT PRIMARY KEY,
        chat_id VARCHAR(255) NOT NULL,
        role ENUM('user','model') NOT NULL,
        content TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

$api_keys = [
    'AIzaSyDJi96OapMnatNcByeR2P_cdaHtz4aYL6I',
    'AIzaSyBybfgLe6ZsqNZlvJt8QzGc8bYxHYdIPdE',
    'AIzaSyDi0Oal7N-uTrWjNOgJEDYgr-i_gxi5kJQ',
    'AIzaSyAFnyITqoihTsMDZPz8q0KE2yCRVY1inhA',
    'AIzaSyBzGRD0cavXpWCU-YOBBczHCiB45J4bRQM',
    'AIzaSyDJi96OapMnatNcByeR2P_cdaHtz4aYL6I',
    'AIzaSyBybfgLe6ZsqNZlvJt8QzGc8bYxHYdIPdE',
    'AIzaSyDi0Oal7N-uTrWjNOgJEDYgr-i_gxi5kJQ',
    'AIzaSyAFnyITqoihTsMDZPz8q0KE2yCRVY1inhA',
    'AIzaSyBzGRD0cavXpWCU-YOBBczHCiB45J4bRQM',
];

function jsonResponse($data) {
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

function postRequest($url, $data) {
    $ch = curl_init($url);

    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE),
    ]);

    $response = curl_exec($ch);

    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        return ['error' => $error ?: 'Unknown error'];
    }

    curl_close($ch);
    return json_decode($response, true);
}

$id = '';
$text = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $contentType = $_SERVER["CONTENT_TYPE"] ?? '';

    if (stripos($contentType, 'application/json') !== false) {
        $data = json_decode(file_get_contents("php://input"), true);
        $id = trim($data['id'] ?? '');
        $text = trim($data['text'] ?? '');
    } else {
        $id = trim($_POST['id'] ?? '');
        $text = trim($_POST['text'] ?? '');
    }
} else {
    $id = trim($_GET['id'] ?? '');
    $text = trim($_GET['text'] ?? '');
}

if ($id === '' || $text === '') {
    jsonResponse([
        'success' => false,
        'error' => 'Missing "id" or "text" parameter'
    ]);
}

$model = 'gemini-2.5-flash';

$stmt = $pdo->prepare("INSERT INTO chats (chat_id, role, content) VALUES (?, 'user', ?)");
$stmt->execute([$id, $text]);

$stmt = $pdo->prepare("SELECT role, content FROM chats WHERE chat_id = ? ORDER BY id DESC LIMIT 5");
$stmt->execute([$id]);
$recent = array_reverse($stmt->fetchAll(PDO::FETCH_ASSOC));

$contents = [];
foreach ($recent as $msg) {
    $contents[] = [
        'role' => $msg['role'],
        'parts' => [['text' => $msg['content']]]
    ];
}

$payload = ['contents' => $contents];
$api_key = $api_keys[array_rand($api_keys)];
$url = "https://generativelanguage.googleapis.com/v1beta/models/{$model}:generateContent?key={$api_key}";

$response = postRequest($url, $payload);

if (isset($response['error'])) {
    jsonResponse([
        'success' => false,
        'error' => $response['error']
    ]);
}

$reply = $response['candidates'][0]['content']['parts'][0]['text'] ?? 'No reply';

$stmt = $pdo->prepare("INSERT INTO chats (chat_id, role, content) VALUES (?, 'model', ?)");
$stmt->execute([$id, $reply]);

jsonResponse([
    'success' => true,
    'reply' => $reply
]);
