<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $text = isset($input['text']) ? trim($input['text']) : '';
} else {
    $text = isset($_GET['text']) ? trim($_GET['text']) : '';
}

if (empty($text)) {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'error' => 'Missing \\text\\ parameter or it is empty'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$apiKey = 'AIzaSyALz_96HxwsZW4Vs-giDNC63VZJhnGQYPQ';
$url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent";

$postData = [
    "contents" => [
        [
            "parts" => [
                [
                    "text" => $text
                ]
            ]
        ]
    ]
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    "X-goog-api-key: $apiKey"
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

$response = curl_exec($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($response === false || $httpcode != 200) {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'error' => 'Error receiving response from Google API.'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$data = json_decode($response, true);

if (isset($data['candidates'][0]['content']['parts'][0]['text'])) {
    $answer = $data['candidates'][0]['content']['parts'][0]['text'];
    echo json_encode([
        'ok' => true,
        'dev' => '@Cactus_Dev',
        'answer' => $answer
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'error' => 'Unexpected response format from Google API.'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
