<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type");

function jsonResponse($data, $ok = true) {
    $data = array_merge(["ok" => $ok, "dev" => "@OnyxApiTeam"], $data);
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

function apiRequest($url, $headers, $data, $json = false) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => $json ? json_encode($data) : $data
    ]);
    $response = curl_exec($curl);
    curl_close($curl);
    return $response;
}

$FN_NAME = "demo-auto-coloring";
$REQUEST_FROM = 10;
$ORIGIN_FROM = "6d3782f244d64cf8";

$LINK = null;
$STYLE = null;
$USER_PROMPT = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents("php://input"), true);
    if (isset($input["link"])) $LINK = $input["link"];
    if (isset($input["style"])) $STYLE = strtolower($input["style"]);
    if (isset($input["prompt"])) $USER_PROMPT = trim($input["prompt"]);
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (isset($_GET["link"])) $LINK = $_GET["link"];
    if (isset($_GET["style"])) $STYLE = strtolower($_GET["style"]);
    if (isset($_GET["prompt"])) $USER_PROMPT = trim($_GET["prompt"]);
}

if (!$LINK) jsonResponse(["error" => "missing link parameter"], false);
if (!$STYLE || !in_array($STYLE, ['ghibli', 'anime'])) jsonResponse(["error" => "missing or invalid style parameter"], false);

$tmpFile = tempnam(sys_get_temp_dir(), "img_") . ".png";
$fileData = @file_get_contents($LINK);
if ($fileData === false) jsonResponse(["error" => "failed to download image"], false);
file_put_contents($tmpFile, $fileData);

$BASE_HEADERS = [
    "accept: application/json, text/plain, */*",
    "fp: e0ab63ed3f7c4efc48c65417fa76b3bc",
    "origin: https://colorifyai.art",
    "referer: https://colorifyai.art/",
    "theme-version: 83EmcUoQTUv50LhNx0VrdcK8rcGexcP35FcZDcpgWsAXEyO4xqL5shCY6sFIWB2Q",
    "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36"
];

$HEADERS_UPLOAD = array_merge($BASE_HEADERS, [
    "fp1: QNigmXWWbrWc+VMNIRAjiAZFYpzPBWUi7f9c/HnzbeQSms8I5JukexgVnUdSqHvs",
    "x-code: 1755808791307",
    "x-guide: peTa7GuOko0LkPA/6udtH0wcsXxPBuwe4uAsaTtLbWJd9nKhxSRwNol7/iOiiQon9mwqgTa8uo0WFm68P7upRLKX1ciS5AfBGVpx+1KNumVMwD9EEqPjpLxD8pPSOwuqcfEl1Oo3JDPiOqHO3R6o7fSLX9IwixQwnU36kn9nJmI="
]);

$postFields = [
    "file" => new CURLFile($tmpFile, "image/png", basename($tmpFile)),
    "fn_name" => $FN_NAME,
    "request_from" => $REQUEST_FROM,
    "origin_from" => $ORIGIN_FROM,
    "link" => $LINK
];

$response = apiRequest("https://api.colorifyai.art/aitools/upload-img", $HEADERS_UPLOAD, $postFields);
$uploadResp = json_decode($response, true);
if (!isset($uploadResp["code"]) || $uploadResp["code"] != 200) jsonResponse(["error" => "upload failed"], false);
$source_image = $uploadResp["data"]["path"];

$HEADERS_CREATE = array_merge($BASE_HEADERS, [
    "content-type: application/json",
    "fp1: dfQ57s2y7HJsDfTk+UDGLonnz27TGsW454oWqJqrv4VCnF+Z0g6rq/MyXE/ARlmu",
    "x-code: 1755808793185",
    "x-guide: WD5UkaqcAYjAeK14aZIHhAdGs86kMnOboMMiRKkasdRWg4dDgBLYhUTJ3TnchMQkApc+3uO/7euA2aelf8EmgnP4rT8tBCJoRfKfVeX6uPWPgiRGUF1Tvef00hO5/ZkFPs14g6vudcjxxEY1lea4xIyoJ6sEtZC2jExxpuJnQds="
]);

if ($USER_PROMPT) {
    $prompt = $USER_PROMPT;
    $lora = [];
} else {
    if ($STYLE === 'anime') {
        $prompt = "(masterpiece), best quality, anime style, vibrant colors, dynamic composition, sharp details, smooth shading, expressive characters, clean lines, high resolution";
        $lora = [];
    } else {
        $prompt = "(masterpiece), ultra detailed, high resolution, cinematic lighting, soft shadows, vibrant colors, intricate details, whimsical style, Ghibli style, fantasy environment, magical atmosphere, highly realistic, photorealistic, masterpiece, award-winning";
        $lora = ["ghibli_style_offset:0.8"];
    }
}

$dataCreate = [
    "fn_name" => $FN_NAME,
    "call_type" => 3,
    "input" => [
        "source_image" => $source_image,
        "prompt" => $prompt,
        "request_from" => $REQUEST_FROM,
        "lora" => $lora
    ],
    "request_from" => $REQUEST_FROM,
    "origin_from" => $ORIGIN_FROM
];

$response = apiRequest("https://api.colorifyai.art/aitools/of/create", $HEADERS_CREATE, $dataCreate, true);
$task = json_decode($response, true);
if (!isset($task["data"]["task_id"])) jsonResponse(["error" => "task creation failed"], false);
$task_id = $task["data"]["task_id"];

$CHECK_URL = "https://api.colorifyai.art/aitools/of/check-status";
do {
    $checkData = [
        "task_id" => $task_id,
        "fn_name" => $FN_NAME,
        "call_type" => 3,
        "request_from" => $REQUEST_FROM,
        "origin_from" => $ORIGIN_FROM
    ];
    $response = apiRequest($CHECK_URL, $HEADERS_CREATE, $checkData, true);
    $statusData = json_decode($response, true);

    if (isset($statusData["data"]["status"]) && $statusData["data"]["status"] == 2) {
        $final_path = $statusData["data"]["result_image"];
        $remoteUrl = "https://temp.colorifyai.art/" . $final_path;
        $imgData = @file_get_contents($remoteUrl);
        if ($imgData === false) jsonResponse(["error" => "failed to download final image"], false);

        $finalName = pathinfo($final_path, PATHINFO_FILENAME) . ".jpg";
        $saveDir = __DIR__ . "/media";
        if (!is_dir($saveDir)) mkdir($saveDir, 0777, true);
        $savePath = $saveDir . "/" . $finalName;

        $tmpWebp = imagecreatefromwebp($remoteUrl);
        if ($tmpWebp === false) jsonResponse(["error" => "failed to convert webp to jpg"], false);
        imagejpeg($tmpWebp, $savePath, 90);
        imagedestroy($tmpWebp);

        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        $scriptDir = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
        $downloadUrl = $scheme . "://" . $host . $scriptDir . "/media/" . $finalName;
        $downloadUrl = str_replace("//media", "/media", $downloadUrl);

        jsonResponse(["result" => $downloadUrl], true);
    }

    if (!isset($statusData["data"]["status"])) jsonResponse(["error" => "status check failed"], false);
    usleep(300000);

} while (true);
