<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $text = trim($input['text'] ?? '');
    $from = strtolower(trim($input['from'] ?? ''));
    $to   = strtolower(trim($input['to'] ?? ''));
} else {
    $text = trim($_GET['text'] ?? '');
    $from = strtolower(trim($_GET['from'] ?? ''));
    $to   = strtolower(trim($_GET['to'] ?? ''));
}

if (empty($text) && empty($to) && empty($from)) {
    echo json_encode([
        "ok" => true,
        "dev" => "@OnyxApiTeam",
        "languages" => getLanguageList()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if (empty($text)) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "Parameter 'text' is required."
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if (empty($to)) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "Parameter 'to' is required."
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

if (empty($from)) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "Parameter 'from' is required."
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$translationResult = GoogleTranslate::translate($from, $to, $text);

echo json_encode($translationResult, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

function getLanguageList() {
    $langsFile = __DIR__ . '/langs.json';
    $langs = [];

    if (file_exists($langsFile)) {
        $content = file_get_contents($langsFile);
        $decoded = json_decode($content, true);
        if (is_array($decoded)) {
            $langs = $decoded;
        }
    }

    usort($langs, function($a, $b) {
        return strcasecmp($a['name'], $b['name']);
    });

    array_unshift($langs, ["code" => "auto", "name" => "Auto Detect"]);
    return $langs;
}

class GoogleTranslate {
    public static function translate($source, $target, $text) {
        $res = self::requestTranslation($source, $target, $text);
        $translation = self::parseTranslation($res);

        return [
            "ok" => true,
            "dev" => "@Cactus_Dev",
            "from" => $source,
            "to" => $target,
            "original" => $text,
            "translated" => $translation
        ];
    }

    protected static function requestTranslation($source, $target, $text) {
        $url = "https://translate.googleapis.com/translate_a/single?client=gtx&sl={$source}&tl={$target}&dt=t&q=" . urlencode($text);
        $opts = [
            "http" => [
                "method" => "GET",
                "header" => "User-Agent: Mozilla/5.0\r\n"
            ]
        ];
        $context = stream_context_create($opts);
        return @file_get_contents($url, false, $context);
    }

    protected static function parseTranslation($json) {
        $data = json_decode($json, true);
        $text = '';
        foreach ($data[0] ?? [] as $s) {
            $text .= $s[0] ?? '';
        }
        return $text;
    }
}
?>
