<?php

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$dev = "@OnyxApiTeam";

function jsonResponse($ok, $data = []) {
    global $dev;

    $response = [
        "ok"  => $ok,
        "dev" => $dev
    ];

    if ($ok) {
        $response["result"] = $data;
    } else {
        $response["error"] = $data;
    }

    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

function fetchTempFileFromUrl($url) {
    $tmpFile = tempnam(sys_get_temp_dir(), 'img_');
    $content = @file_get_contents($url);

    if (!$content) {
        return false;
    }

    file_put_contents($tmpFile, $content);
    return $tmpFile;
}

function analyzeImageFile($tmpFile, $fileName) {
    $mime = mime_content_type($tmpFile);

    $postFields = [
        'file' => new CURLFile($tmpFile, $mime, $fileName)
    ];

    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL            => "https://api.theyseeyourphotos.com/deductions",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $postFields,
        CURLOPT_HTTPHEADER     => [
            "accept: application/json, text/plain, */*",
            "origin: https://theyseeyourphotos.com",
            "referer: https://theyseeyourphotos.com/",
            "user-agent: Mozilla/5.0"
        ]
    ]);

    $response = curl_exec($ch);
    $error    = curl_error($ch);

    curl_close($ch);

    if ($error) {
        return ["error" => "Curl error: $error"];
    }

    $data = json_decode($response, true);

    if (
        !$data ||
        !isset($data['success']) ||
        !$data['success']
    ) {
        return ["error" => "API Error or Invalid Response"];
    }

    return ["result" => $data['data']];
}

$tmpFile  = null;
$fileName = null;

if (
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    isset($_FILES['file']) &&
    $_FILES['file']['error'] === UPLOAD_ERR_OK
) {
    $tmpFile  = $_FILES['file']['tmp_name'];
    $fileName = $_FILES['file']['name'];
} elseif (
    isset($_REQUEST['url']) &&
    filter_var($_REQUEST['url'], FILTER_VALIDATE_URL)
) {
    $url = $_REQUEST['url'];
    $tmpFile = fetchTempFileFromUrl($url);

    if (!$tmpFile) {
        jsonResponse(false, "Failed to download image from URL");
    }

    $fileName = basename(parse_url($url, PHP_URL_PATH));
} else {
    jsonResponse(false, "No valid file or URL provided");
}

$result = analyzeImageFile($tmpFile, $fileName);

if (isset($url)) {
    unlink($tmpFile);
}

if (isset($result['error'])) {
    jsonResponse(false, $result['error']);
}

if (
    isset($result['result']['people']) &&
    $result['result']['people'] === "false"
) {
    jsonResponse(false, "No people detected in the image");
}

jsonResponse(true, $result['result']);
