<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
error_reporting(0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $prompt = isset($input['prompt']) ? trim($input['prompt']) : null;
    $userId = isset($input['userid']) ? trim($input['userid']) : null;
} else {
    $prompt = isset($_GET['prompt']) ? trim($_GET['prompt']) : null;
    $userId = isset($_GET['userid']) ? trim($_GET['userid']) : null;
}

if (!$prompt || !$userId) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'description' => "'prompt or userId' is null"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$userId = preg_replace('/^#\/chat\//', '', $userId);
$userKey = "#/chat/" . $userId;

const API_URL = "https://api.binjie.fun/api/generateStream";
const HEADERS = [
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36',
    'Accept: application/json, text/plain, */*',
    'Content-Type: application/json',
    'origin: https://chat18.aichatos68.com',
    'referer: https://chat18.aichatos68.com/',
    'accept-language: fa-IR,fa;q=0.9,en-US;q=0.8,en;q=0.7'
];

$payload = json_encode([
    "prompt" => $prompt,
    "userId" => $userKey,
    "network" => true,
    "system" => "",
    "withoutContext" => false,
    "stream" => false
]);

$randIP = mt_rand(1, 255) . '.' . mt_rand(0, 255) . '.' . mt_rand(0, 255) . '.' . mt_rand(1, 254);

$headers = array_merge(HEADERS, [
    'X-FORWARDED-FOR: ' . $randIP
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, API_URL);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
if ($response === false) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'description' => 'cURL error: ' . curl_error($ch)
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    curl_close($ch);
    exit;
}
curl_close($ch);

echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'prompt' => $prompt,
    'userId' => $userId,
    'response' => $response
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
