<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $text = $input['text'] ?? null;
} else {
    $text = $_GET['text'] ?? null;
}

if (!$text) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'پارامتر text الزامی است'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$url = 'https://hoshi-app.ir/api/chat-gpt.php?text=' . urlencode($text);
$response = @file_get_contents($url);
$data = json_decode($response, true);

if (isset($data['result'])) {
    echo json_encode([
        'ok' => true,
        'dev' => '@OnyxApiTeam',
        'result' => $data['result']
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'خطا در اتصال به سرور'
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
