<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

$text = $_GET['text'] ?? $_POST['text'] ?? json_decode(file_get_contents('php://input'), true)['text'] ?? null;
if (empty($text)) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Missing \\text\\ parameter or it is empty'
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

$payload = [
    "interface" => "puter-chat-completion",
    "driver" => "openrouter",
    "test_mode" => false,
    "method" => "complete",
    "args" => [
        "messages" => [
            ["content" => $text]
        ],
        "model" => "openrouter:x-ai/grok-3-mini"
    ],
    "auth_token" => "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0IjoiYXUiLCJ2IjoiMC4wLjAiLCJ1dSI6IjBWbi9Bb3V0VHpXS3o1dVByNGdkQVE9PSIsImF1IjoidXozbFhRWUhWdk9iM1FFUDBvc3ZmUT09IiwicyI6Img2bU9pMnBMdnQxMkxMU2l4c05HK0E9PSIsImlhdCI6MTc2MTc3MDQzNn0.mXMh9KzI4oskET52wPFk5NvMwPQY2hE7snShroztHek"
];

$ch = curl_init('https://api.puter.com/drivers/call');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload, JSON_UNESCAPED_SLASHES));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Accept: */*',
    'Accept-Language: fa-IR,fa;q=0.9,en-US;q=0.8,en;q=0.7',
    'Connection: keep-alive',
    'Content-Type: text/plain;actually=json',
    'DNT: 1',
    'Origin: http://localhost:8080',
    'Referer: http://localhost:8080/',
    'Sec-Fetch-Dest: empty',
    'Sec-Fetch-Mode: cors',
    'Sec-Fetch-Site: cross-site',
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36',
    'sec-ch-ua: "Google Chrome";v="141", "Not?A_Brand";v="8", "Chromium";v="141"',
    'sec-ch-ua-mobile: ?0',
    'sec-ch-ua-platform: "Windows"'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$answer = '';
if ($response !== false) {
    $json = json_decode($response, true);
    if (isset($json['result']['message']['content'])) {
        $answer = $json['result']['message']['content'];
    }
}

$answer = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($m) {
    return mb_convert_encoding(pack('H*', $m[1]), 'UTF-8', 'UTF-16BE');
}, $answer);

echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'text' => $answer
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
