<?php
header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    exit;
}

$text = null;

if (isset($_GET['text']) && trim($_GET['text']) !== "") {
    $text = trim($_GET['text']);
} elseif (isset($_POST['text']) && trim($_POST['text']) !== "") {
    $text = trim($_POST['text']);
} else {
    $inputJSON = file_get_contents("php://input");
    if (!empty($inputJSON)) {
        $jsonData = json_decode($inputJSON, true);
        if (isset($jsonData['text']) && trim($jsonData['text']) !== "") {
            $text = trim($jsonData['text']);
        }
    }
}

if (!$text) {
    http_response_code(400);
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "text parameter is required or empty"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$api = "https://sii3.top/api/grok4.php?text=" . urlencode($text);
$r = file_get_contents($api);

if (!$r) {
    http_response_code(400);
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "bad request"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$j = json_decode($r, true);

if (!isset($j['response'])) {
    http_response_code(400);
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "bad request"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

echo json_encode([
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "result" => $j["response"]
], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
