<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

$base_url = "https://rest.imdbapi.dev/v2/";

function fetch($url) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => ['User-Agent: PHP']
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($response === false || $http_code !== 200) {
        return ['error' => 'Failed to fetch data or invalid request'];
    }

    return json_decode($response, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $search = isset($input['search']) ? trim($input['search']) : null;
    $id = isset($input['id']) ? trim($input['id']) : null;
} else {
    $search = isset($_GET['search']) ? trim($_GET['search']) : null;
    $id = isset($_GET['id']) ? trim($_GET['id']) : null;
}

if (isset($search) && !empty(trim($search))) {
    $search = urlencode(trim($search));
    $url = $base_url . "search/titles?query={$search}";
    $data = fetch($url);

    if (isset($data['error'])) {
        http_response_code(400);
        echo json_encode([
            'ok' => false,
            'dev' => '@OnyxApiTeam',
            'error' => $data['error']
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        exit;
    }

    http_response_code(200);
    echo json_encode([
        'ok' => true,
        'dev' => '@OnyxApiTeam',
        'mode' => 'search',
        'results' => $data
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;

} elseif (isset($id) && !empty(trim($id))) {
    $id = urlencode(trim($id));
    $url = $base_url . "titles/{$id}";
    $data = fetch($url);

    if (isset($data['error'])) {
        http_response_code(400);
        echo json_encode([
            'ok' => false,
            'dev' => '@OnyxApiTeam',
            'error' => $data['error']
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        exit;
    }

    http_response_code(200);
    echo json_encode([
        'ok' => true,
        'dev' => '@OnyxApiTeam',
        'mode' => 'info',
        'title' => $data
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;

} else {
    http_response_code(400);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Please provide either search or id parameter'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}
