<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

$prompt = $_GET['prompt'] ?? $_POST['prompt'] ?? null;
$image_url = $_GET['image_url'] ?? $_POST['image_url'] ?? null;

if (!$prompt && !$image_url) {
    $input = json_decode(file_get_contents('php://input'), true);
    $prompt = $input['prompt'] ?? null;
    $image_url = $input['image_url'] ?? null;
}

if (empty($prompt) && empty($image_url)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'prompt or image_url required']);
    exit;
}

$contents = [];

if ($image_url) {
    $imgData = @file_get_contents($image_url);
    if ($imgData === false) {
        http_response_code(400);
        echo json_encode(['ok' => false, 'error' => 'Failed to fetch image from URL.']);
        exit;
    }
    $finfo = new finfo(FILEINFO_MIME_TYPE);
    $mimeType = $finfo->buffer($imgData);
    if (!$mimeType) $mimeType = 'application/octet-stream';
    $base64 = base64_encode($imgData);
    $dataUri = "data:$mimeType;base64,$base64";

    $contents[] = [
        'parts' => [
            [
                'inlineData' => [
                    'mimeType' => $mimeType,
                    'data' => $base64,
                    'dataUri' => $dataUri
                ]
            ]
        ]
    ];
}

if ($prompt) {
    $contents[] = [
        'text' => "You are an advanced AI visual analyst. In your **first and only message**, provide a complete and beautifully structured description of the image in 2–3 short paragraphs. The first paragraph should describe the visible details — objects, people, lighting, colors, and setting. The second should interpret the mood, meaning, or possible story. The third, if needed, should express emotional or artistic tone. Avoid being too long or too technical, but make it sound natural and vivid. 

**Important:** Do NOT include any bounding boxes, coordinates, or technical detection data — only provide a text description.

User request: $prompt"
    ];
}

$payload = [
    'model' => 'gemini-2.0-flash-lite',
    'contents' => $contents
];

$ch = curl_init('https://us-central1-infinite-chain-295909.cloudfunctions.net/gemini-proxy-staging-v1');
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_HTTPHEADER => [
        'accept: */*',
        'accept-language: fa-IR,fa;q=0.9,en-US;q=0.8,en;q=0.7',
        'content-type: application/json',
        'user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36'
    ]
]);

$response = curl_exec($ch);
$errno = curl_errno($ch);
$err = curl_error($ch);
curl_close($ch);

if ($errno) {
    http_response_code(502);
    echo json_encode(['ok' => false, 'error' => $err]);
    exit;
}

$data = json_decode($response, true);
$content = $data['candidates'][0]['content']['parts'][0]['text'] ?? null;

echo json_encode(['ok' => $content ? true : false, 'content' => $content], JSON_UNESCAPED_UNICODE);
