<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$dev='@OnyxApiTeam';

function ok($data=[]){
    global $dev;
    echo json_encode(['ok'=>true,'dev'=>$dev,'data'=>$data],JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
    exit;
}

function error($msg){
    global $dev;
    echo json_encode(['ok'=>false,'dev'=>$dev,'error'=>$msg],JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
    exit;
}

$url=$_GET['url']??null;
if(!$url) error('Parameter "url" is required');
if(!filter_var($url,FILTER_VALIDATE_URL)) error('Invalid URL');

$sizeKB=$_GET['size_kb']??null;
if(!$sizeKB) error('Parameter "size_kb" is required');

if($sizeKB!=='auto'){
    if(!is_numeric($sizeKB) || $sizeKB<=0) error('size_kb must be positive number or "auto"');
    $sizeKB=(int)$sizeKB;
}

$mediaDir=__DIR__.'/media/';
if(!file_exists($mediaDir)) mkdir($mediaDir,0755,true);

$ext=strtolower(pathinfo(parse_url($url,PHP_URL_PATH),PATHINFO_EXTENSION));
$ext=$ext==='jpg'?'jpeg':$ext;
if(!in_array($ext,['jpeg','png'])) error('Only JPEG/PNG allowed');

$filename=uniqid('img_',true).'.'.$ext;
$path=$mediaDir.$filename;

$baseUrl=(isset($_SERVER['HTTPS'])&&$_SERVER['HTTPS']==='on'?'https':'http').'://'.$_SERVER['HTTP_HOST'].rtrim(dirname($_SERVER['SCRIPT_NAME']),'/').'/media/';
$outputUrl=$baseUrl.$filename;

$imgContent=@file_get_contents($url);
if(!$imgContent) error('Failed to download image');

file_put_contents($path,$imgContent);

$info=@getimagesize($path);
if(!$info){ unlink($path); error('Invalid image file'); }

$mime=$info['mime'];
if(!in_array($mime,['image/jpeg','image/png'])){ unlink($path); error('Only JPEG/PNG allowed'); }

$imageRes=$mime==='image/jpeg'?imagecreatefromjpeg($path):imagecreatefrompng($path);

function smartTarget($w,$h,$kb){
    $area=$w*$h;
    if($area<600000) return max(120,min(230,$kb*0.62));
    if($area<2000000) return max(210,min(420,$kb*0.55));
    return max(300,min(720,$kb*0.48));
}

if($sizeKB==='auto'){
    $origKB=round(strlen($imgContent)/1024,2);
    $sizeKB=smartTarget($info[0],$info[1],$origKB);
}

function compress_ultra_fast($img,$out,$target,$mime){
    $initialQ = $mime==='image/jpeg' ? 78 : 7;
    if($mime==='image/jpeg') imagejpeg($img,$out,$initialQ);
    else imagepng($img,$out,floor((100-$initialQ)/10));

    $size=filesize($out)/1024;
    if($size <= $target) return $size;

    $ratio = $target / $size;
    $adjustedQ = max(22, min(85, intval($initialQ * $ratio * 1.32)));

    if($mime==='image/jpeg'){
        imagejpeg($img,$out,$adjustedQ);
    } else {
        imagepng($img,$out,floor((100-$adjustedQ)/10));
    }

    return filesize($out)/1024;
}

$compSize=compress_ultra_fast($imageRes,$path,$sizeKB,$mime);
imagedestroy($imageRes);

ok([
    'original_kb'=>round(strlen($imgContent)/1024,2),
    'compressed_kb'=>round($compSize,2),
    'url'=>$outputUrl
]);
?>
