<?php

header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once 'config.php';
require_once 'libs/ResponseHandler.php';
require_once 'libs/UrlValidator.php';
require_once 'libs/TypeDetector.php';
require_once 'libs/HttpClient.php';
require_once 'libs/CaptionExtractor.php';
require_once 'libs/MediaParser.php';
require_once 'libs/InstagramDownloader.php';

$url = '';

if (isset($_GET['url'])) {
    $url = $_GET['url'];
}
elseif (isset($_POST['url'])) {
    $url = $_POST['url'];
}
elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $contentType = $_SERVER['CONTENT_TYPE'] ?? '';
    if (strpos($contentType, 'application/json') !== false) {
        $jsonInput = file_get_contents('php://input');
        $data = json_decode($jsonInput, true);
        if ($data && isset($data['url'])) {
            $url = $data['url'];
        }
    }
}

$downloader = new InstagramDownloader($url);
$downloader->process();