<?php

class HttpClient {
    public static function post($url, $postFields, $customHeaders = [], $cookieFile = null) {
        $headers = array_merge([
            "Accept: */*",
            "Content-Type: application/x-www-form-urlencoded",
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36",
        ], $customHeaders);

        $ch = curl_init($url);
        $options = [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($postFields),
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_TIMEOUT => CURL_TIMEOUT,
            CURLOPT_CONNECTTIMEOUT => CURL_CONNECT_TIMEOUT,
        ];
        
        if ($cookieFile) {
            $options[CURLOPT_COOKIEJAR] = $cookieFile;
            $options[CURLOPT_COOKIEFILE] = $cookieFile;
        }
        
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        curl_close($ch);
        
        return $response;
    }
    
    public static function get($url, $customHeaders = [], $cookieFile = null) {
        $headers = array_merge([
            "Accept: */*",
            "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36",
        ], $customHeaders);

        $ch = curl_init($url);
        $options = [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HEADER => false,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_TIMEOUT => CURL_TIMEOUT,
            CURLOPT_CONNECTTIMEOUT => CURL_CONNECT_TIMEOUT,
        ];
        
        if ($cookieFile) {
            $options[CURLOPT_COOKIEJAR] = $cookieFile;
            $options[CURLOPT_COOKIEFILE] = $cookieFile;
        }
        
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        curl_close($ch);
        
        return $response;
    }
}
