<?php

class MediaParser {
    public static function parse($html, $type) {
        libxml_use_internal_errors(true);
        $doc = new DOMDocument();
        $doc->loadHTML($html);
        
        $results = [];
        
        if ($type === "profile") {
            $img = $doc->getElementsByTagName("img")->item(0);
            if ($img) {
                $src = $img->getAttribute("src");
                if ($src) {
                    $results[] = ["type" => "image", "download_url" => $src, "preview_url" => $src];
                }
            }
        } elseif ($type === "story") {
            foreach ($doc->getElementsByTagName("img") as $img) {
                $src = $img->getAttribute("src");
                if ($src) {
                    $results[] = ["type" => "image", "download_url" => $src, "preview_url" => $src];
                }
            }
            foreach ($doc->getElementsByTagName("video") as $video) {
                $poster = $video->getAttribute("poster");
                $src = $video->getElementsByTagName("source")->item(0)?->getAttribute("src");
                if ($src) {
                    $results[] = ["type" => "video", "download_url" => $src, "preview_url" => $poster];
                }
            }
        } else {
            foreach ($doc->getElementsByTagName("img") as $img) {
                $src = $img->getAttribute("src");
                if ($src) {
                    $results[] = ["type" => "image", "download_url" => $src, "preview_url" => $src];
                }
            }
            foreach ($doc->getElementsByTagName("video") as $video) {
                $poster = $video->getAttribute("poster");
                $src = $video->getElementsByTagName("source")->item(0)?->getAttribute("src");
                if ($src) {
                    $results[] = ["type" => "video", "download_url" => $src, "preview_url" => $poster];
                }
            }
        }
        
        return $results;
    }
}