<?php

class TypeDetector {
    public static function detect($url) {
        $url = strtolower($url);
        
        if (preg_match('#/reels?/|/p/|/tv/#', $url)) {
            return "media";
        }
        
        if (preg_match('#/stories/#', $url)) {
            return "story";
        }
        
        if (preg_match('#instagram\\.com/[^/]+/?$#', $url)) {
            return "profile";
        }
        
        return null;
    }
    
    public static function getApiUrl($type) {
        return match($type) {
            "profile" => API_BASE_URL . "/dp",
            "story"   => API_BASE_URL . "/story",
            default   => API_BASE_URL . "/media",
        };
    }
}
