<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $ip = $input['ip'] ?? $_SERVER['REMOTE_ADDR'];
} else {
    $ip = $_GET['ip'] ?? $_SERVER['REMOTE_ADDR'];
}

$apiURL = "https://ipwho.is/{$ip}";

$response = @file_get_contents($apiURL);
$data = json_decode($response, true);

if (!$response || !$data['success']) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => $data['message'] ?? "خطا در دریافت اطلاعات IP"
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

unset($data['success']);

echo json_encode([
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "result" => $data
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);

?>
