<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $q = htmlspecialchars($input['q'] ?? "");
    $rand_val = $input['rand'] ?? null;
} else {
    $q = htmlspecialchars($_REQUEST["q"] ?? "");
    $rand_val = $_REQUEST["rand"] ?? null;
}

$random = true;

if ($q !== "") {
    $random = false;
} else {
    if (isset($rand_val)) {
        if (is_string($rand_val)) {
            $rand_val = strtolower($rand_val);
            $random = ($rand_val === 'true' || $rand_val === '1' || $rand_val === 'yes');
        } else {
            $random = (bool)$rand_val;
        }
    }
}

$page = random_int(1, 10) * 100;

header("Content-Type: " . ($random ? "image/jpg" : "application/json; charset=utf-8"));

if ($random) {
    readfile(search($q, $page, $random));
} else {
    $result = [
        "ok" => true,
        "dev" => "@OnyxApiTeam",
        "result" => search($q, $page, $random)
    ];
    echo json_encode($result, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

function search(string $search = "", int $getNumber = 100, bool $random = true)
{
    $payload = [
        "text" => $search,
        "model" => "lexica-aperture-v3.5",
        "searchMode" => "images",
        "source" => "search",
        "cursor" => $getNumber
    ];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, "https://lexica.art/api/infinite-prompts");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json"
    ]);

    $response = json_decode(curl_exec($ch), true);
    curl_close($ch);

    if (!isset($response["images"])) return "Error Connect To WebSite";

    if ($random) {
        return "https://image.lexica.art/full_jpg/" .  $response["images"][array_rand($response["images"])]["id"];
    }

    $list = [];
    foreach ($response["images"] as $image) {
        $list[] = [
            "webp" => "https://image.lexica.art/full_webp/" . $image["id"],
            "jpg" => "https://image.lexica.art/full_jpg/" . $image['id'],
            "width" =>  $image["width"],
            "height" => $image["height"]
        ];
    }

    return $list;
}