<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

$result = [
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "result" => []
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if (isset($input["pid"]) && !empty($input["pid"]) && is_numeric($input["pid"])) {
        $pid = $input["pid"];
        $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=single&pid=$pid&vstatus=yes";
    } elseif (isset($input["page"])  && !empty($input["page"]) && is_numeric($input["page"])) {
        $page = $input["page"];
        $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=load_more&type=music&page=$page";
    } elseif (isset($input["s"])  && !empty($input["s"])) {
        $search = base64_encode($input["s"]);
        $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=search&key=$search&page=1";
    } else $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=load_more&type=music&page=1";
} else {
    if (isset($_REQUEST["pid"]) && !empty($_REQUEST["pid"]) && is_numeric($_REQUEST["pid"])) {
        $pid = $_REQUEST["pid"];
        $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=single&pid=$pid&vstatus=yes";
    } elseif (isset($_REQUEST["page"])  && !empty($_REQUEST["page"]) && is_numeric($_REQUEST["page"])) {
        $page = $_REQUEST["page"];
        $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=load_more&type=music&page=$page";
    } elseif (isset($_REQUEST["s"])  && !empty($_REQUEST["s"])) {
        $search = base64_encode($_REQUEST["s"]);
        $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=search&key=$search&page=1";
    } else $url = "https://mrjavan.com/wp-admin/admin-ajax.php?action=cma&task=load_more&type=music&page=1";
}

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "accept-encoding: gzip",
        "connection: Keep-Alive",
        "host: mrjavan.com",
        "user-agent: Mozilla/5.0 (Linux; Android 12; SM-G991B Build/SKQ1.210828.001; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/12.0.0 Chrome/96.0.4664.45 Mobile Safari/537.36"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    $result["ok"] = false;
    $result["result"] = ["error" => $err];
} else {
    $result["result"] = json_decode($response, true);
}

echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
?>