<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

$options = JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES;

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

function fetchHTML($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 10.0; Win64; x64)");
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $html = curl_exec($ch);
    curl_close($ch);
    return mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8');
}

function getNodeValueOrNull($node) {
    return $node && trim($node->nodeValue) !== '' ? mb_convert_encoding(trim($node->nodeValue), 'UTF-8', 'auto') : null;
}

function getAttrOrNull($node, $attr) {
    return $node && $node->hasAttribute($attr) ? mb_convert_encoding($node->getAttribute($attr), 'UTF-8', 'auto') : null;
}

$dev = "@OnyxApiTeam";

function sendError($msg) {
    global $dev, $options;
    echo json_encode(["ok"=>true,"dev"=>$dev,"error"=>$msg], $options);
    exit;
}

$page = isset($_GET['page']) ? max(1,intval($_GET['page'])) : 1;

if (isset($_GET['q'])) {
    $keyword = urlencode($_GET['q']);
    $url = "https://musicdel.ir/page/$page/?s=$keyword";
    $html = fetchHTML($url);
    if (!$html) { sendError("site not reachable"); }

    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    libxml_clear_errors();
    $xpath = new DOMXPath($dom);

    $results = [];
    foreach ($xpath->query("//figure[contains(@class,'result')]") as $figure) {
        $linkNode = $xpath->query(".//a", $figure)->item(0);
        $href = getAttrOrNull($linkNode, "href");
        preg_match("#/single-tracks/(\d+)/#", $href, $matches);
        $id = isset($matches[1]) ? intval($matches[1]) : null;

        $titleNode = $xpath->query(".//figcaption/span[1]", $figure)->item(0);
        $artistNode = $xpath->query(".//figcaption/span[2]", $figure)->item(0);
        $imgNode = $xpath->query(".//img", $figure)->item(0);

        $results[] = [
            "id" => $id,
            "title" => getNodeValueOrNull($titleNode),
            "artist" => getNodeValueOrNull($artistNode),
            "img" => getAttrOrNull($imgNode, "src")
        ];
    }

    $total_pages = 1;
    $pagination = $xpath->query("//div[contains(@class,'pagination')]");
    if($pagination->length){
        $pages = $xpath->query(".//a[contains(@class,'page-numbers')]", $pagination->item(0));
        $lastPage = 1;
        foreach($pages as $p){
            $num = intval(trim($p->nodeValue));
            if($num > $lastPage) $lastPage = $num;
        }
        $total_pages = $lastPage;
    }

    echo json_encode([
        "ok"=>true,
        "dev"=>$dev,
        "page"=>$page,
        "total_pages"=>$total_pages,
        "results"=>!empty($results)?$results:null
    ], $options);
    exit;
}

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);
    if (!$id) { sendError("invalid id"); }

    $url = "https://musicdel.ir/single-tracks/$id/";
    $html = fetchHTML($url);
    if (!$html) { sendError("site not reachable"); }

    $dom = new DOMDocument();
    libxml_use_internal_errors(true);
    $dom->loadHTML($html);
    libxml_clear_errors();
    $xpath = new DOMXPath($dom);

    $imgNode = $xpath->query("//figure[contains(@class,'wp-block-table')]//img")->item(0);
    $artistNode = $xpath->query("//table[contains(@class,'songsinfo')]//tr[1]/td[1]")->item(0);
    $titleNode  = $xpath->query("//table[contains(@class,'songsinfo')]//tr[1]/td[2]")->item(0);

    $downloads = [];
    foreach ($xpath->query("//div[contains(@class,'dls')]//a") as $a) {
        $href = getAttrOrNull($a, "href");
        $text = getNodeValueOrNull($a);
        if ($href && strpos($href, "dl.musicdel.ir") !== false) {
            $downloads[] = [
                "url" => $href,
                "quality" => $text
            ];
        }
    }

    $track = [
        "id" => $id,
        "title" => getNodeValueOrNull($titleNode),
        "artist" => getNodeValueOrNull($artistNode),
        "img" => getAttrOrNull($imgNode, "src"),
        "downloads" => !empty($downloads)?$downloads:null
    ];

    echo json_encode(["ok"=>true,"dev"=>$dev,"results"=>$track], $options);
    exit;
}

sendError("parameter q or id missing");
