<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=utf-8");

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") exit;

const KIE_TOKEN = "Bearer 876a1744dc14b3b683411e668afe1214";

function kieHeaders() {
    return [
        "Accept: */*",
        "Content-Type: application/json",
        "Authorization: " . KIE_TOKEN,
        "Origin: https://kie.ai",
        "Referer: https://kie.ai/",
        "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36",
        "DNT: 1",
        "Cache-Control: no-cache",
        "Pragma: no-cache"
    ];
}

function kieGenerate(array $urls, string $prompt): array {
    $payload = [
        "model" => "nano-banana-pro",
        "input" => [
            "prompt" => $prompt,
            "image_input" => $urls,
            "aspect_ratio" => "1:1",
            "resolution" => "1K",
            "output_format" => "png"
        ]
    ];

    $ch = curl_init("https://api.kie.ai/api/v1/jobs/createTask");
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => kieHeaders(),
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_TIMEOUT => 20
    ]);
    $res = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($res, true);
    if (!$json || $json["code"] !== 200) throw new Exception("Create failed");

    $taskId = $json["data"]["taskId"];
    $start = time();

    while (true) {
        $ch = curl_init("https://api.kie.ai/api/v1/jobs/recordInfo?taskId=" . $taskId);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => kieHeaders(),
            CURLOPT_TIMEOUT => 15
        ]);
        $res = curl_exec($ch);
        curl_close($ch);

        $json = json_decode($res, true);
        $data = $json["data"] ?? [];

        if (($data["state"] ?? "") === "success" && !empty($data["resultJson"])) {
            $result = json_decode($data["resultJson"], true);
            return $result["resultUrls"];
        }

        if (!empty($data["failMsg"])) throw new Exception($data["failMsg"]);
        if (time() - $start > 60) throw new Exception("Timeout");

        sleep(2);
    }
}

try {
    $input = json_decode(file_get_contents("php://input"), true) ?: [];
    $url   = $_GET["url"] ?? $_POST["url"] ?? $input["url"] ?? null;
    $prompt= $_GET["prompt"] ?? $_POST["prompt"] ?? $input["prompt"] ?? null;

    if (!$url || !$prompt) throw new Exception("url and prompt are required");

    $imageUrls = array_filter(array_map('trim', explode(",", $url)));

    $images = kieGenerate($imageUrls, $prompt);

    echo json_encode([
        "ok" => true,
        "dev" => "@OnyxApiTeam",
        "images" => $images
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => $e->getMessage()
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
