<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

$allowedModels = ['alloy','ash','ballad','coral','echo','fable','nova','onyx','sage','shimmer'];

function getInput($key) {
    $rawInput = file_get_contents('php://input');
    if ($rawInput) {
        $json = json_decode($rawInput, true);
        if (json_last_error() === JSON_ERROR_NONE && isset($json[$key])) {
            return trim($json[$key]);
        }
    }
    if (isset($_POST[$key])) return trim($_POST[$key]);
    if (isset($_GET[$key])) return trim($_GET[$key]);
    return '';
}

$inputText = getInput('text');
$model = getInput('model');

if ($inputText === '') {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Parameter "text" is required'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

if ($model === '') {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Parameter "model" is required'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

if (!in_array($model, $allowedModels)) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'Invalid model. Allowed: ' . implode(', ', $allowedModels)
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$url = "https://www.openai.fm/api/generate";
$postFields = [
    'input' => $inputText,
    'voice' => $model
];
$headers = [
    "Accept: */*",
    "Origin: https://www.openai.fm",
    "Referer: https://www.openai.fm/",
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36"
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
$response = curl_exec($ch);
curl_close($ch);

if (!$response) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'No response from server'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$folder = __DIR__ . '/media';
if (!is_dir($folder)) mkdir($folder, 0777, true);

function generate_uuid() {
    return sprintf(
        '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
        mt_rand(0, 0xffff), mt_rand(0, 0xffff),
        mt_rand(0, 0xffff),
        mt_rand(0, 0x0fff) | 0x4000,
        mt_rand(0, 0x3fff) | 0x8000,
        mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
}

$filename = generate_uuid() . '.ogg';
$filepath = $folder . '/' . $filename;
file_put_contents($filepath, $response);

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$scriptPath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
$domain = $protocol . $_SERVER['HTTP_HOST'];
$resultUrl = $domain . $scriptPath . '/media/' . $filename;

echo json_encode([
    'ok' => true,
    'dev' => '@Cactus_Dev',
    'result' => $resultUrl
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);