<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

function downloadFile($url, $savePath) {
    $fp = fopen($savePath, 'w+');
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_FILE => $fp,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 60,
        CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)',
    ]);
    curl_exec($ch);
    curl_close($ch);
    fclose($fp);
}

function getPinterestMedia($url) {
    $ua = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36';
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => $ua,
    ]);
    $html = curl_exec($ch);
    curl_close($ch);

    $media = null;

    if (preg_match('/"contentUrl"\s*:\s*"([^"]+\.mp4[^"]*)"/', $html, $m)) {
        $media = stripslashes(str_replace('\\u002F', '/', $m[1]));
    } 
    elseif (preg_match('/https:\/\/i\.pinimg\.com\/(?!originals)[a-zA-Z0-9\/._-]+\.(jpg|jpeg|png|gif)/i', $html, $m)) {
        $media = $m[0];
    }

    if ($media) {
        $ext = pathinfo(parse_url($media, PHP_URL_PATH), PATHINFO_EXTENSION);
        $name = uniqid('pin_') . '.' . $ext;
        $dir = __DIR__ . '/media';
        if (!is_dir($dir)) mkdir($dir, 0777, true);
        $path = $dir . '/' . $name;
        downloadFile($media, $path);

        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $protocol . '://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
        return $host . '/media/' . $name;
    }

    return false;
}

// Determine request method and input
$url = '';
$contentType = $_SERVER['CONTENT_TYPE'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (stripos($contentType, 'application/json') !== false) {
        $input = json_decode(file_get_contents('php://input'), true);
        $url = $input['url'] ?? '';
    } else {
        $url = $_POST['url'] ?? '';
    }
} else {
    $url = $_GET['url'] ?? '';
}

if (!$url) {
    http_response_code(400);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'query param "url" is not set'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

$link = getPinterestMedia($url);

if (!$link) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'media not found or invalid link'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

http_response_code(200);
echo json_encode([
    'ok' => true,
    'dev' => '@OnyxApiTeam',
    'download_url' => $link
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
