<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');
if($_SERVER['REQUEST_METHOD']==='OPTIONS'){http_response_code(200); exit;}

$dev='@OnyxApiTeam';
$channel=$_GET['channel']??json_decode(file_get_contents('php://input'),1)['channel']??null;
if(!$channel) exit(json(['ok'=>false,'dev'=>$dev,'error'=>'Channel parameter is required']));

$url=trim($channel);
$url=strpos($url,'@')===0 ? "https://t.me/s/".substr($url,1) : preg_replace('#^(https?://)?(www\.)?t\.me/#','',$url);
$parts=explode('/',$url);
$username=($parts[0]==='s'&&isset($parts[1]))?$parts[1]:$parts[0];
$url=$username?"https://t.me/s/$username":null;
if(!$url) exit(json(['ok'=>false,'dev'=>$dev,'error'=>'Invalid channel format']));

$ch=curl_init();
curl_setopt_array($ch,[CURLOPT_URL=>$url,CURLOPT_RETURNTRANSFER=>1,CURLOPT_FOLLOWLOCATION=>1,CURLOPT_USERAGENT=>'Mozilla/5.0',CURLOPT_TIMEOUT=>15]);
$html=curl_exec($ch);
$code=curl_getinfo($ch,CURLINFO_HTTP_CODE);
curl_close($ch);
if(!$html||$code!==200) exit(json(['ok'=>false,'dev'=>$dev,'error'=>"Failed to fetch channel (HTTP $code)"]));

preg_match_all('/https?:\/\/t\.me\/proxy\?[^"\s<>]+|tg:\/\/proxy\?[^"\s<>]+/i',$html,$m);
$proxies=array_map(function($l){return str_replace(['tg://proxy','&amp;'],['https://t.me/proxy','&'],html_entity_decode($l));},array_values(array_unique($m[0])));
if(!$proxies) exit(json(['ok'=>false,'dev'=>$dev,'error'=>'No proxy links found in this channel']));

$handle = strpos($channel,'@')===0 ? $channel : '@'.end(explode('/',trim($channel)));
echo json(['ok'=>true,'dev'=>$dev,'channel'=>$handle,'proxies'=>$proxies]);

function json($a){return json_encode($a,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);}
?>
