<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

function sendJsonError(string $message, string $dev = '@OnyxApiTeam'): void
{
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(
        [
            'ok'    => false,
            'dev'   => $dev,
            'error' => $message,
        ],
        JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE
    );
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $text = $input['text'] ?? null;
    $size = $input['size'] ?? '250x250';
} else {
    $text = $_GET['text'] ?? null;
    $size = $_GET['size'] ?? '250x250';
}

if (!preg_match('/^\d{2,4}x\d{2,4}$/', $size)) {
    sendJsonError('Invalid size format. The size parameter must be in WIDTHxHEIGHT format, e.g., 250x250.');
}

if ($text === null || trim($text) === '') {
    sendJsonError('The "text" parameter is required and cannot be empty.');
}

$text = trim($text);

$apiUrl = sprintf(
    'https://api.qrserver.com/v1/create-qr-code/?size=%s&data=%s',
    urlencode($size),
    urlencode($text)
);

$context = stream_context_create([
    'http' => [
        'timeout' => 5,
    ],
]);

$img = @file_get_contents($apiUrl, false, $context);

if ($img === false) {
    sendJsonError('Failed to retrieve the QR Code image from the external service.');
}

header('Content-Type: image/png');
echo $img;
exit;
