<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if (!in_array($_SERVER['REQUEST_METHOD'], ['GET', 'POST'])) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "Method not allowed"
    ]);
    http_response_code(405);
    exit();
}

$html = file_get_contents("https://www.time.ir/");

$doc = new DOMDocument();
libxml_use_internal_errors(true);
$doc->loadHTML($html);
libxml_clear_errors();

$xpath = new DOMXPath($doc);

$quoteNode = $xpath->query("//div[contains(@class,'ExpandableText_text')]//div")->item(0);
$text = $quoteNode ? trim($quoteNode->textContent) : "";

$authorNode = $xpath->query("//a[contains(@class,'BrainyQuoteAuthor')]")->item(0);
$author = $authorNode ? trim($authorNode->textContent) : "";

echo json_encode([
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "quote" => [
        "text" => $text,
        "author" => $author
    ]
], JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
