<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

function curl_get(string $url, int $timeout = 5): ?string {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_USERAGENT => 'Mozilla/5.0'
    ]);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data ?: null;
}

function fetch_music(): ?array {
    $html_base = curl_get("https://taw-bio.ir/f/arc/music/all~1~all~bst");
    if (!$html_base) return null;

    preg_match('/id="userPass"[^>]*value="([^"]+)"/', $html_base, $matches);
    if (empty($matches[1])) return null;
    $userkey = $matches[1];

    $rand = rand(1, 10);
    $url = "https://taw-bio.ir/f/arc/music/all~1~all~bst~{$rand}.json?u_cache=176357&pass={$userkey}&cpost=";
    $json = curl_get($url);
    if (!$json) return null;

    $data = json_decode($json, true);
    if (empty($data['items'])) return null;

    $item = $data['items'][array_rand($data['items'])];
    $item_id = $item['id'];

    $html_item = curl_get("https://taw-bio.ir/f/item/music/{$item_id}");
    if (!$html_item) return null;

    preg_match_all(
        '/https:\/\/aud[12]\.taw-bio\.ir[^\s"\']+\.mp3/',
        $html_item,
        $mp3_matches
    );

    preg_match(
        '/https:\/\/aud[12]\.taw-bio\.ir[^\s"\']+\/450\.jpeg/',
        $html_item,
        $cover_matches
    );

    $mp3_link = $mp3_matches[0][0] ?? null;
    $cover_link = $cover_matches[0] ?? null;

    if (!$mp3_link) return null;

    return [
        "cover" => $cover_link,
        "mp3" => $mp3_link
    ];
}

$media = fetch_music() ?? fetch_music();

if (!$media) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "No music found"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

echo json_encode([
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "media" => $media
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
