<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') exit;

$uploadDir = __DIR__ . '/media/';
is_dir($uploadDir) || mkdir($uploadDir, 0755, true);

function genName(string $ext,int $len=6):string{
    return substr(bin2hex(random_bytes($len)),0,$len).".$ext";
}

function getFileUrl(string $file):string{
    $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off');
    $protocol = $https?'https://':'http://';
    $host = $_SERVER['HTTP_HOST'];
    $path = str_replace('\\','/',realpath(__DIR__.'/media/'.$file));
    $doc = str_replace('\\','/',realpath($_SERVER['DOCUMENT_ROOT']));
    $rel = str_replace($doc,'',$path);
    return $protocol.$host.$rel;
}

$img=null;
if($_SERVER['REQUEST_METHOD']==='GET') $img=$_GET['img']??null;
elseif($_SERVER['REQUEST_METHOD']==='POST'){
    $ct=$_SERVER['CONTENT_TYPE']??'';
    if(str_contains($ct,'application/json')){
        $j=json_decode(file_get_contents('php://input'),true);
        $img=$j['img']??$img;
    }else{
        $img=$_POST['img']??$img;
    }
}

if(!$img || !filter_var($img,FILTER_VALIDATE_URL)){
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','result'=>'Invalid or missing img'],JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
    exit;
}

$tmp=$uploadDir.genName('jpg',4);
$data=@file_get_contents($img);
if(!$data){
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','result'=>'Failed to download image'],JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
    exit;
}
file_put_contents($tmp,$data);

$ch=curl_init('https://app.hooshbox.ir/api/apps/api/v1/demo_removebg');
curl_setopt_array($ch,[
    CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_POST=>true,
    CURLOPT_POSTFIELDS=>['file_img'=>new CURLFile($tmp,'image/jpeg',basename($tmp)),'high_res'=>'0'],
    CURLOPT_HTTPHEADER=>['accept: application/*']
]);
$res=curl_exec($ch);
$code=curl_getinfo($ch,CURLINFO_HTTP_CODE);
curl_close($ch);
unlink($tmp);

if($code===200 && $res){
    $out=$uploadDir.genName('png');
    file_put_contents($out,$res);
    $url=getFileUrl(basename($out));
    echo json_encode(['ok'=>true,'dev'=>'@OnyxApiTeam','result'=>$url],JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
    function_exists('fastcgi_finish_request') && fastcgi_finish_request();
    $delScript="<?php sleep(30); @unlink('$out');";
    $delFile=$uploadDir.'d_'.uniqid().'.php';
    file_put_contents($delFile,$delScript);
    exec(PHP_BINARY." $delFile > /dev/null 2>&1 &");
    exit;
}

echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','result'=>'Failed to process image','http_code'=>$code],JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT);
