<?php
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ob_start();

require_once('./rubino/rubino.php');
require_once('./network/exception.php');

function fetch_auth_and_profile() {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://zero1plus.ir/api/getRubikaDownloaderWithLinkConfig");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, []);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Accept: application/json"]);
    $res = curl_exec($ch);
    curl_close($ch);
    $list = json_decode($res, true);
    if (!is_array($list)) return [null, null];
    $random = $list[array_rand($list)];
    $parts = explode(":", $random, 2);
    $auth = $parts[0] ?? null;
    $my_profile_id = $parts[1] ?? null;
    return [$auth, $my_profile_id];
}

list($auth_token, $my_profile_id) = fetch_auth_and_profile();
if (!$auth_token || !$my_profile_id) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "No valid auth/profile_id found"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$bot = new RubinoPHP($auth_token);

header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
header("Access-Control-Allow-Credentials: true");

$action = $_GET['action'] ?? $_POST['action'] ?? null;
$username = $_GET['username'] ?? $_POST['username'] ?? null;
$url = $_GET['url'] ?? $_POST['url'] ?? null;
$id = $_GET['id'] ?? $_POST['id'] ?? null;

$raw = file_get_contents("php://input");
$json = json_decode($raw, true);

if (!$username && !empty($json['username'])) $username = $json['username'];
if (!$url && !empty($json['url'])) $url = $json['url'];
if (!$id && !empty($json['id'])) $id = $json['id'];

try {
    $profile_id = null;

    if ($username) {
        $username = ltrim($username, "@");
        $res = $bot->isExistUsername($username);
        if (empty($res['data']['profile'])) throw new Exception("Profile not found");
        $profile_id = $res['data']['profile']['id'] ?? null;
    }

    switch ($action) {
        case 'profile':
            echo json_encode([
                "ok" => true,
                "dev" => "@OnyxApiTeam",
                "data" => $res['data']['profile'] ?? new stdClass()
            ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
            break;

        case 'posts':
            if (!$profile_id) throw new Exception("Profile ID not found");
            $posts = $bot->getProfilePosts($profile_id);
            echo json_encode([
                "ok" => true,
                "dev" => "@OnyxApiTeam",
                "data" => $posts['data']['posts'] ?? []
            ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
            break;

        case 'download':
            if (!$url) throw new Exception("URL required");
            $post = $bot->getPostByShareLink($url);
            $data = $post['data'] ?? [];
            if (isset($data['post']) && is_array($data['post'])) {
                $data = array_merge($data['post'], array_diff_key($data, ["post" => true]));
            }
            echo json_encode([
                "ok" => true,
                "dev" => "@OnyxApiTeam",
                "data" => $data
            ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
            break;

        case 'stories':
            if (!$profile_id) throw new Exception("Profile ID not found");
            $idsRes = $bot->getStoryIds($my_profile_id, $profile_id);
            $ids = $idsRes['data']['story_ids'] ?? [];
            if (is_string($ids)) $ids = array_filter(array_map('trim', explode(',', $ids)));
            if (empty($ids)) throw new Exception("No story ids found");
            $all_stories = [];
            $seen = [];
            foreach (array_chunk($ids, 20) as $chunk) {
                $storiesRes = $bot->getStory($profile_id, $chunk, $my_profile_id);
                $stories = $storiesRes['data']['stories'] ?? [];
                foreach ($stories as $s) {
                    $sid = $s['id'] ?? null;
                    if ($sid === null || !isset($seen[$sid])) {
                        $seen[$sid] = true;
                        $all_stories[] = $s;
                    }
                }
            }
            echo json_encode([
                "ok" => true,
                "dev" => "@OnyxApiTeam",
                "data" => $all_stories
            ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
            break;

        case 'highlights':
            if (!$profile_id) throw new Exception("Target profile ID not found");
            $hlRes = $bot->getProfileHighlights($my_profile_id, $profile_id);
            $highlights = $hlRes['data']['highlights'] ?? [];
            if (empty($id)) {
                echo json_encode([
                    "ok" => true,
                    "dev" => "@OnyxApiTeam",
                    "data" => $highlights
                ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
                break;
            }
            $target_hl = null;
            foreach ($highlights as $hl) {
                if ((string)$hl['highlight_id'] === (string)$id) $target_hl = $hl;
            }
            if (!$target_hl) throw new Exception("Highlight not found");
            $hid = $target_hl['highlight_id'] ?? $id;
            $idsRes = $bot->getHighlightStoryIds($my_profile_id, $profile_id, $hid);
            $ids = $idsRes['data']['story_ids'] ?? [];
            if (is_string($ids)) $ids = array_filter(array_map('trim', explode(',', $ids)));
            if (empty($ids)) {
                $target_hl['stories'] = [];
            } else {
                $all_stories = [];
                $seen = [];
                foreach (array_chunk($ids, 20) as $chunk) {
                    $storiesRes = $bot->getHighlightStories($my_profile_id, $profile_id, $hid, $chunk);
                    $stories = $storiesRes['data']['stories'] ?? [];
                    foreach ($stories as $s) {
                        $sid = $s['id'] ?? null;
                        if ($sid === null || !isset($seen[$sid])) {
                            $seen[$sid] = true;
                            $all_stories[] = $s;
                        }
                    }
                }
                $target_hl['stories'] = $all_stories;
            }
            echo json_encode([
                "ok" => true,
                "dev" => "@OnyxApiTeam",
                "data" => [$target_hl]
            ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
            break;

        default:
            throw new Exception("Invalid action");
    }
} catch (Exception $e) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
?>
