<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $siteURL = $input['url'] ?? null;
    $format = $input['format'] ?? 'jpg';
} else {
    $siteURL = $_GET['url'] ?? null;
    $format = isset($_GET['format']) ? $_GET['format'] : 'jpg';
}

if (!$siteURL) {
    header('Content-Type: application/json');
    echo json_encode([
        "ok" => true,
        "dev" => "@OnyxApiTeam",
        "error" => "url parmaeter is reqiured"
    ], JSON_PRETTY_PRINT);
    exit;
}


header('Content-Type: text/html');

$accessKey = 'CM0tkRZzeakspA';
$apiBaseUrl = 'https://api.screenshotone.com/take';

$apiUrl = $apiBaseUrl . '?' . http_build_query([
    'access_key' => $accessKey,
    'url' => $siteURL,
    'format' => $format,
    'block_ads' => 'true',
    'block_cookie_banners' => 'true',
    'block_banners_by_heuristics' => 'false',
    'block_trackers' => 'true',
    'delay' => '0',
    'timeout' => '60',
    'response_type' => 'by_format',
    'image_quality' => '80'
]);

echo "<img src=\"" . htmlspecialchars($apiUrl) . "\" alt=\"Screenshot of " . htmlspecialchars($siteURL) . "\" />";

?>