<?php

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

$apiKey = 'ygszwosL1I66vtkVrxSMa87TEaWineNexaT6k6DUH03uUQVHuNZhrU0GK6pB';

function createShortLink($url, $alias = null)
{
    global $apiKey;

    $data = [
        'url' => $url,
        'public' => 1
    ];

    if ($alias !== null && $alias !== '') {
        $data['alias'] = $alias;
    }

    $ch = curl_init('https://zaya.io/api/v1/links');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . $apiKey,
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

    $response = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $result = json_decode($response, true);

    if ($httpcode === 201 && isset($result['data'])) {
        $d = $result['data'];
        return [
            'ok' => true,
            'dev' => '@OnyxApiTeam',
            'data' => [
                'id' => $d['id'] ?? null,
                'title' => $d['title'] ?? null,
                'url' => $d['url'] ?? '',
                'short_url' => $d['short_url'] ?? ''
            ]
        ];
    }

    return [
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'message' => $result['message'] ?? 'Unexpected error.'
    ];
}

function getLinkDetails($id)
{
    global $apiKey;

    $url = "https://zaya.io/api/v1/links/{$id}";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $apiKey,
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $response = curl_exec($ch);
    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $result = json_decode($response, true);

    if ($httpcode === 200 && isset($result['data'])) {
        $d = $result['data'];
        return [
            'ok' => true,
            'dev' => '@OnyxApiTeam',
            'data' => [
                'id' => $d['id'] ?? null,
                'title' => $d['title'] ?? null,
                'url' => $d['url'] ?? '',
                'short_url' => $d['short_url'] ?? '',
                'clicks' => $d['clicks'] ?? null,
                'created_at' => $d['created_at'] ?? ''
            ]
        ];
    }

    return [
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'message' => $result['message'] ?? 'Error fetching link details.'
    ];
}

if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'ok' => false,
        'dev' => '@Cactus_Dev',
        'message' => 'Method Not Allowed. Use GET or POST.'
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $url = $input['url'] ?? null;
    $alias = $input['alias'] ?? null;
    $id = $input['id'] ?? null;
} else {
    $url = $_GET['url'] ?? null;
    $alias = $_GET['alias'] ?? null;
    $id = $_GET['id'] ?? null;
}

if ($url) {
    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        http_response_code(400);
        echo json_encode([
            'ok' => false,
            'dev' => '@OnyxApiTeam',
            'message' => 'Invalid "url" parameter.'
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        exit;
    }
    echo json_encode(createShortLink($url, $alias), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($id) {
    if (!is_numeric($id)) {
        http_response_code(400);
        echo json_encode([
            'ok' => false,
            'dev' => '@OnyxApiTeam',
            'message' => 'Invalid "id" parameter.'
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        exit;
    }
    echo json_encode(getLinkDetails($id), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

http_response_code(400);
echo json_encode([
    'ok' => false,
    'dev' => '@OnyxApiTeam',
    'message' => 'Missing "url" or "id" parameter.'
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
exit;
