<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST");

$downloadDir = __DIR__ . '/media';
if (!file_exists($downloadDir)) mkdir($downloadDir, 0777, true);

function curl_request($url, $postData = null) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    if ($postData !== null) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    }
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

$spotifyUrl = null;
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['url'])) {
    $spotifyUrl = filter_var($_GET['url'], FILTER_SANITIZE_URL);
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    if (isset($data['url'])) $spotifyUrl = filter_var($data['url'], FILTER_SANITIZE_URL);
}

if (!$spotifyUrl) {
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','error'=>'Missing "url" parameter'], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

if (!preg_match('#^https://open\.spotify\.com/track/([a-zA-Z0-9]+)#', $spotifyUrl, $matches)) {
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','error'=>'Only Spotify track URLs are supported'], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

$trackId = $matches[1] ?? null;

$songDetailsJson = curl_request('https://www.spotimp3.com/api/song-details?url=' . urlencode($spotifyUrl));
$songDetails = json_decode($songDetailsJson, true);

if (!isset($songDetails['songs'][0])) {
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','error'=>'Song details not found'], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

$ssong = $songDetails['songs'][0];

$downloadDataJson = curl_request('https://sssspotify.com/api/download/get-url', json_encode(['url'=>$spotifyUrl]));
$downloadData = json_decode($downloadDataJson, true);

if (!isset($downloadData['originalVideoUrl'])) {
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','error'=>'Failed to get download link'], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

$downloadUrl = 'https://sssspotify.com' . $downloadData['originalVideoUrl'];

$binaryData = curl_request($downloadUrl);
if (!$binaryData) {
    echo json_encode(['ok'=>false,'dev'=>'@OnyxApiTeam','error'=>'Failed to download song file'], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    exit;
}

$filenameSafe = $trackId . ".mp3";
$savePath = $downloadDir.'/'.$filenameSafe;
file_put_contents($savePath, $binaryData);

$relativePath = str_replace($_SERVER['DOCUMENT_ROOT'], '', realpath($savePath));
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!=='off') ? 'https' : 'http';
$downloadLink = $protocol.'://'.$_SERVER['HTTP_HOST'].'/'.ltrim(str_replace('\\','/',$relativePath), '/');

$response = [
    'ok'=>true,
    'dev'=>'@OnyxApiTeam',
    'track_data'=>[
        'track_id' => $trackId,
        'title' => $ssong['title'] ?? null,
        'artist' => $ssong['artist'] ?? null,
        'album' => $ssong['album'] ?? null,
        'thumbnail' => $ssong['thumbnail'] ?? null,
        'duration' => $ssong['duration'] ?? null,
        'download_url' => $downloadLink ?? null
    ]
];

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
