import sys
import json
import os
import urllib.parse
import requests
import warnings

warnings.filterwarnings("ignore", category=DeprecationWarning)

try:
    from yt_dlp import YoutubeDL
except ImportError:
    print(json.dumps({"ok": False, "error": "yt-dlp is not installed"}))
    sys.exit(1)

if len(sys.argv) < 2:
    print(json.dumps({"ok": False, "error": "Missing Spotify URL"}))
    sys.exit(1)

spotify_url = sys.argv[1]
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
DOWNLOAD_FOLDER = os.path.join(BASE_DIR)
os.makedirs(DOWNLOAD_FOLDER, exist_ok=True)

try:
    encoded_url = urllib.parse.quote(spotify_url, safe='')
    SPOTDOWN_API = f"https://spotdown.org/api/song-details?url={encoded_url}"
    resp = requests.get(SPOTDOWN_API, headers={
        "accept": "application/json, text/plain, */*",
        "referer": "https://spotdown.org/",
        "user-agent": "Mozilla/5.0"
    })
    resp.raise_for_status()
    data = resp.json()
    track = data.get("songs", [])[0]
    title = track.get("title")
    artist = track.get("artist")
except Exception as e:
    print(json.dumps({"ok": False, "error": f"Metadata fetch failed: {str(e)}"}))
    sys.exit(1)

query = f"{title} {artist} audio site:music.youtube.com"
ydl_opts = {
    "format": "bestaudio/best",
    "outtmpl": os.path.join(DOWNLOAD_FOLDER, "%(id)s.%(ext)s"),
    "postprocessors": [{
        "key": "FFmpegExtractAudio",
        "preferredcodec": "mp3",
        "preferredquality": "192",
    }],
    "quiet": True,
    "ignoreerrors": True,
    "noplaylist": True,
}

try:
    with YoutubeDL(ydl_opts) as ydl:
        info = ydl.extract_info(f"ytsearch1:{query}", download=True)
        if not info or "entries" not in info or len(info["entries"]) == 0:
            raise Exception("No results found on YouTube Music")
        video = info["entries"][0]
        file_id = video.get("id")
        filename = f"{file_id}.mp3"
except Exception as e:
    print(json.dumps({"ok": False, "error": f"Download failed: {str(e)}"}))
    sys.exit(1)

DOMAIN = "https://onyxapi.ir/v1/spotify"
download_link = f"{DOMAIN}/{filename}"

print(json.dumps({
    "ok": True,
    "dev": "@OnyxApiTeam",
    "track_data": {
        "track_id": file_id,
        "title": title,
        "artist": artist,
        "download_url": download_link
    }
}))
