<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

function curl_get(string $url, int $timeout = 5): ?string {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CONNECTTIMEOUT => $timeout,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_USERAGENT => 'Mozilla/5.0'
    ]);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data ?: null;
}

function fetch_image(): ?string {
    $html_base = curl_get("https://taw-bio.ir/f/arc/image/all~3~all~bst");
    if (!$html_base) return null;

    preg_match('/id="userPass"[^>]*value="([^"]+)"/', $html_base, $matches);
    if (empty($matches[1])) return null;
    $userkey = $matches[1];

    $rand = rand(1, 500);
    $url = "https://taw-bio.ir/f/arc/image/all~3~all~bst~{$rand}.json?u_cache=176348&pass={$userkey}&cpost=";
    $json = curl_get($url);
    if (!$json) return null;

    $data = json_decode($json, true);
    if (empty($data['items'])) return null;

    $item = $data['items'][array_rand($data['items'])];
    $item_id = $item['id'];

    $html_item = curl_get("https://taw-bio.ir/f/item/image/{$item_id}");
    if (!$html_item) return null;

    preg_match_all('/https:\/\/img2\.taw-bio\.ir[^\s"\']+/', $html_item, $imgs);
    $imgs = array_values(array_filter($imgs[0] ?? [], fn($i) => strpos($i, '/thumbs/') === false));
    return $imgs ? $imgs[array_rand($imgs)] : null;
}

$img_url = fetch_image() ?? fetch_image();

if (!$img_url) {
    echo json_encode([
        "ok" => false,
        "dev" => "@OnyxApiTeam",
        "error" => "No image found"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

echo json_encode([
    "ok" => true,
    "dev" => "@OnyxApiTeam",
    "img_url" => $img_url
], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
