<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

$result = [
    "ok" => false,
    "dev" => "@Cactus_Dev",
    "result" => "ok"
];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $mail = $input['mail'] ?? null;
} else {
    $mail = $_REQUEST['mail'] ?? null;
}

if ($mail && !empty($mail)) {
    if (!filter_var($mail, FILTER_VALIDATE_EMAIL)) {
        $result["ok"] = false;
        $result["dev"] = "@Cactus_Dev";
        $result["result"] = "Mail Is Invalid";
        die(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
    }
    $result["ok"] = true;
    $result["result"] = getInbox($mail);
    die(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
}


$domain = getDomain();
if (!$domain) {
    $result["ok"] = false;
    $result["dev"] = "@Cactus_Dev";
    $result["result"] = "Domain Is Not Found";
    die(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
}
$domain = $domain[array_rand($domain)];

$payload = [
    "domain" => $domain,
    "name" => mail_name(),
    "token" => ""
];
$response = POST("https://api.internal.temp-mail.io/api/v3/email/new", $payload);

if (!isset($response["response"]["email"])) die("error creacte mail");

$orgMail = $response["response"]["email"];
$token = $response["response"]["token"];

$payload = [
    "device_id" => "91f8c3a3-38bb-4e1f-adfe-62f5732631b6",
    "email" => $orgMail,
    "subscribe" => true,
    "token" => $token
];

$response = POST("https://api.internal.temp-mail.io/api/v3/device/subscribe", $payload);

if ($response["code"] == 200) {
    $result["ok"] = true;
    $result["result"] = $orgMail;
    mails($orgMail);
    die(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
} else {
    $result["ok"] = false;
    $result["dev"] = "@Cactus_Dev";
    $result["result"] = "Bad Request Code : " . $response["code"];
    die(json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
}

function mail_name($length = 7)
{
    $string = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    $result = "";
    for ($i = 0; $i < $length; $i++) $result .= $string[rand(0, strlen($string) - 1)];
    return $result;
}

function POST($url, $payload)
{
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => [
            "accept-encoding: gzip",
            "connection: Keep-Alive",
            "content-type: application/json; charset=UTF-8",
            "host: api.internal.temp-mail.io",
            "user-agent: okhttp/4.12.0"
        ],
    ]);
    $response = json_decode(curl_exec($curl), true);
    $code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $err = curl_error($curl);
    curl_close($curl);
    return [
        "response" => $response,
        "status" => !$err,
        "code" => $code
    ];
}

function getDomain()
{
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.internal.temp-mail.io/api/v3/domains",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "accept-encoding: gzip",
            "connection: Keep-Alive",
            "host: api.internal.temp-mail.io",
            "user-agent: okhttp/4.12.0"
        ],
    ]);
    $response = json_decode(curl_exec($curl), true);
    $err = curl_error($curl);
    curl_close($curl);
    if ($err) return false;
    $domain_list = [];
    foreach ($response["domains"] as $domain) {
        $domain_list[] = $domain["name"];
    }
    return $domain_list;
}

function getInbox($mail)
{

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.internal.temp-mail.io/api/v3/email/$mail/messages",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "GET",
        CURLOPT_HTTPHEADER => [
            "accept-encoding: gzip",
            "connection: Keep-Alive",
            "host: api.internal.temp-mail.io",
            "user-agent: okhttp/4.12.0"
        ],
    ]);
    $response = curl_exec($curl);
    curl_close($curl);
    return json_decode($response , true);
}

function mails($mail)
{
    if (!file_exists("mails.json")) file_put_contents("mails.json", "[]");
    $user_mails = json_decode(file_get_contents("mails.json"), true);
    $user_mails[] = [
        "mail" => $mail,
        "ip" => getUserIP()
    ];
    file_put_contents("mails.json", json_encode($user_mails, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));
}
function getUserIP()
{
    if (!empty($_SERVER["HTTP_CLIENT_IP"])) return $_SERVER["HTTP_CLIENT_IP"];
    elseif (!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) return $_SERVER["HTTP_X_FORWARDED_FOR"];
    else return $_SERVER["REMOTE_ADDR"];
}
