<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

define('DB_HOST', 'localhost');
define('DB_USER', 'cactusde_test');
define('DB_PASS', 'www09148215271s');
define('DB_NAME', 'cactusde_test');

$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($mysqli->connect_error) {
    echo json_encode(["ok"=>false,"dev"=>"@Cactus_Dev","error"=>"Database connection failed"]);
    exit;
}

$mysqli->query("
CREATE TABLE IF NOT EXISTS mails (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mail VARCHAR(255) NOT NULL,
    ip VARCHAR(45) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

function sendResponse($ok, $data = null, $error = null){
    $response = ["ok" => $ok, "dev" => "@Cactus_Dev"];
    if($ok && $data !== null) $response["data"] = $data;
    if(!$ok && $error !== null) $response["error"] = $error;
    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

function getUserIP(){
    if(!empty($_SERVER["HTTP_CLIENT_IP"])) return $_SERVER["HTTP_CLIENT_IP"];
    if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"])) return $_SERVER["HTTP_X_FORWARDED_FOR"];
    return $_SERVER["REMOTE_ADDR"];
}

function generateMailName($length = 7){
    return substr(bin2hex(random_bytes($length)),0,$length);
}

function postAPI($url, $payload){
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => ["Content-Type: application/json; charset=UTF-8"]
    ]);
    $response = json_decode(curl_exec($ch), true);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return ["response" => $response, "code" => $code];
}

function getDomains(){
    $ch = curl_init("https://api.internal.temp-mail.io/api/v3/domains");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["user-agent: okhttp/4.12.0"]);
    $res = json_decode(curl_exec($ch), true);
    curl_close($ch);
    return isset($res["domains"]) ? array_column($res["domains"], "name") : false;
}

function getInbox($mail){
    $ch = curl_init("https://api.internal.temp-mail.io/api/v3/email/$mail/messages");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["user-agent: okhttp/4.12.0"]);
    $res = json_decode(curl_exec($ch), true);
    curl_close($ch);
    return is_array($res) ? $res : false;
}

function saveMail($mysqli, $mail){
    $ip = getUserIP();
    $stmt = $mysqli->prepare("INSERT INTO mails(mail, ip) VALUES(?, ?)");
    $stmt->bind_param("ss", $mail, $ip);
    $stmt->execute();
    $stmt->close();
}

$action = $_REQUEST['action'] ?? '';

if($action === 'new'){
    $domains = getDomains();
    if(!$domains) sendResponse(false, null, "No available domains found");

    $domain = $domains[array_rand($domains)];
    $payload = ["domain"=>$domain,"name"=>generateMailName(),"token"=>""];
    $response = postAPI("https://api.internal.temp-mail.io/api/v3/email/new", $payload);

    if(!isset($response["response"]["email"])) sendResponse(false, null, "Error creating mail");

    $mail = $response["response"]["email"];
    $token = $response["response"]["token"];

    $subscribePayload = ["device_id"=>"91f8c3a3-38bb-4e1f-adfe-62f5732631b6", "email"=>$mail, "subscribe"=>true, "token"=>$token];
    $subscribeResp = postAPI("https://api.internal.temp-mail.io/api/v3/device/subscribe", $subscribePayload);

    if($subscribeResp["code"] != 200) sendResponse(false, null, "Subscription failed");

    saveMail($mysqli, $mail);
    sendResponse(true, ["mail" => $mail]);
}

if($action === 'inbox'){
    $mail = $_REQUEST['mail'] ?? '';
    if(!$mail) sendResponse(false, null, "Mail parameter is required");
    if(!filter_var($mail, FILTER_VALIDATE_EMAIL)) sendResponse(false, null, "Mail is invalid");

    $inbox = getInbox($mail);
    if(!$inbox) sendResponse(false, null, "Cannot fetch inbox or inbox is empty");

    $messages = [];
    foreach($inbox as $msg){
        $messages[] = [
            "from" => $msg["from"] ?? "",
            "subject" => $msg["subject"] ?? "",
            "body" => $msg["body_text"] ?? ""
        ];
    }
    sendResponse(true, ["messages" => $messages]);
}

sendResponse(false, null, "Invalid action");
