<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit;
}

class TiktokDownloader {
    private $baseUrl = "https://ssstik.io";

    public function downloadTiktokVideo($tiktokUrl) {
        $initialPage = $this->curlGet($this->baseUrl);
        $ttToken = $this->extractTtToken($initialPage);

        $postData = http_build_query([
            'id' => $tiktokUrl,
            'locale' => 'en',
            'tt' => $ttToken ?: 'RkxMQVpl',
            'debug' => 'ab=1&loc=IR&ip=' . $this->getClientIP()
        ]);

        $headers = [
            'HX-Request: true',
            'HX-Trigger: _gcaptcha_pt',
            'HX-Target: target',
            'HX-Current-URL: ' . $this->baseUrl . '/',
            'Content-Type: application/x-www-form-urlencoded',
            'User-Agent: Mozilla/5.0'
        ];

        $response = $this->curlPost($this->baseUrl . "/abc?url=dl", $postData, $headers);
        return $this->parseResponse($response);
    }

    private function curlGet($url) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_USERAGENT => 'Mozilla/5.0'
        ]);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    private function curlPost($url, $data, $headers = []) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $data,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_USERAGENT => 'Mozilla/5.0'
        ]);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    private function extractTtToken($html) {
        preg_match('/<input type="hidden" name="tt"\s+value="([^"]+)"/', $html, $m);
        return $m[1] ?? null;
    }

    private function parseResponse($html) {
        $result = [
            'ok' => true,
            'dev' => '@OnyxApiTeam',
            'data' => [
                'author' => [
                    'name' => '',
                    'avatar' => ''
                ],
                'video_info' => [
                    'likes' => '',
                    'comments' => '',
                    'shares' => '',
                    'cover_image' => ''
                ],
                'download_links' => []
            ]
        ];

        preg_match('/<h2>([^<]+)<\/h2>/', $html, $m1);
        if ($m1) $result['data']['author']['name'] = trim($m1[1]);

        preg_match('/<img class="result_author" src="([^"]+)"/', $html, $m2);
        if ($m2) $result['data']['author']['avatar'] = $m2[1];

        preg_match_all('/<div class="d-flex flex-1[^>]*>.*?<div>([\d.KM]+)<\/div>/s', $html, $m3);
        if (!empty($m3[1])) {
            $result['data']['video_info']['likes'] = $m3[1][0] ?? '';
            $result['data']['video_info']['comments'] = $m3[1][1] ?? '';
            $result['data']['video_info']['shares'] = $m3[1][2] ?? '';
        }

        preg_match('/background-image: url\(([^)]+)\)/', $html, $m4);
        if ($m4) $result['data']['video_info']['cover_image'] = trim($m4[1], "'\"");

        $this->extractLinks($html, $result['data']);
        $result['ok'] = !empty($result['data']['download_links']);
        return $result;
    }

    private function extractLinks($html, &$data) {
        $dom = new DOMDocument();
        @$dom->loadHTML($html);
        $xp = new DOMXPath($dom);
        $buttons = $xp->query('//a[contains(@class, "download_link")]');

        foreach ($buttons as $btn) {
            $href = $btn->getAttribute('href');
            $text = trim($btn->textContent);
            $class = strtolower($btn->getAttribute('class'));

            if (!$href || strpos($href, 'apps.apple.com') !== false || strpos($href, 'play.google.com') !== false) continue;

            $type = $this->detType($text, $class);

            if ($this->validLink($href)) {
                $data['download_links'][] = [
                    'type' => $type,
                    'url' => $href,
                    'quality' => $this->quality($type)
                ];
            }
        }
    }

    private function detType($text, $class) {
        $t = strtolower($text);
        if (strpos($class, 'without_watermark_hd') !== false || strpos($t, 'hd') !== false) return 'without_watermark_hd';
        if (strpos($class, 'without_watermark') !== false) return 'without_watermark';
        if (strpos($class, 'music') !== false || strpos($t, 'mp3') !== false) return 'mp3';
        return 'video';
    }

    private function quality($type) {
        return [
            'without_watermark_hd' => 'HD',
            'without_watermark' => 'Standard',
            'mp3' => 'Audio',
            'video' => 'Standard'
        ][$type] ?? 'Unknown';
    }

    private function validLink($url) {
        foreach (['.mp4', '.mp3', '.webm', '.m4a'] as $e) if (strpos($url, $e) !== false) return true;
        if (strpos($url, 'tikcdn.io') !== false) return true;
        return false;
    }

    private function getClientIP() {
        return $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? '46.100.87.207';
    }
}

$tiktokUrl = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents("php://input"), true);
    $tiktokUrl = $input['url'] ?? $_POST['url'] ?? '';
} else {
    $tiktokUrl = $_GET['url'] ?? '';
}

if (!$tiktokUrl) {
    echo json_encode([
        'ok' => false,
        'dev' => '@OnyxApiTeam',
        'error' => 'TikTok URL is required'
    ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    exit;
}

$downloader = new TiktokDownloader();
echo json_encode(
    $downloader->downloadTiktokVideo($tiktokUrl),
    JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT
);
?>
