<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');

const API_URL = "https://api.time.ir/v1/time/fa/time/now";
const API_KEY = "ZAVdqwuySASubByCed5KYuYMzb9uB2f7";

header('Content-Type: application/json;charset=UTF-8');

$timeData = fetchData(API_URL);
$year = $timeData['data']['jalali']['year'];
$month = $timeData['data']['jalali']['month'];
$eventsData = fetchData(getEventsUrl($year, $month));

echo formatResponse($timeData, $eventsData);

function fetchData($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'x-api-key: ' . API_KEY,
        'Content-Type: application/json;charset=UTF-8'
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function getEventsUrl($year, $month) {
    return "https://api.time.ir/v1/event/fa/events/calendar?year={$year}&month={$month}&day=0&base1=0&base2=1&base3=2";
}

function extractFields($obj, $fields) {
    $result = [];
    foreach ($fields as $field) {
        if (isset($obj[$field])) {
            $result[$field] = $obj[$field];
        }
    }
    return $result;
}

function formatEvent($event) {
    $fields = [
        'title', 'gregorian_year', 'gregorian_month', 'gregorian_day', 'gregorian_day_title',
        'jalali_year', 'jalali_month', 'jalali_day', 'jalali_day_title',
        'hijri_year', 'hijri_month', 'hijri_day', 'hijri_day_title',
        'is_holiday', 'date_string'
    ];
    return extractFields($event, $fields);
}

function extractData($data) {
    $dateFields = ['astrological_sign', 'gregorian', 'jalali', 'hijri'];
    $result = [
        'ok' => $data['status_code'] === 200,
        'developer' => '@CactusDev'
    ];
    if ($data['status_code'] !== 200) {
        $result['error_message'] = $data['error'];
    }
    $result['result'] = [
        'current_time' => $data['data']['time'],
        'date_info' => extractFields($data['data'], $dateFields)
    ];
    return $result;
}

function formatResponse($timeData, $eventsData) {
    $resData = extractData($timeData);
    $events = $eventsData['data']['event_list'];
    $todayJalali = $timeData['data']['jalali'];
    $todayEvents = array_filter($events, function($event) use ($todayJalali) {
        return isset($event['jalali_year'], $event['jalali_month'], $event['jalali_day']) &&
            $event['jalali_year'] == $todayJalali['year'] &&
            $event['jalali_month'] == $todayJalali['month'] &&
            $event['jalali_day'] == $todayJalali['day'];
    });
    $resData['result']['day_events'] = array_map('formatEvent', array_values($todayEvents));
    $resData['result']['month_events'] = array_map('formatEvent', $events);
    return json_encode($resData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}

?>